package com.zehong.web.controller.checktask;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TUserInspect;
import com.zehong.system.service.ITUserInspectService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 【请填写功能名称】Controller
 * 
 * @author zehong
 * @date 2023-11-08
 */
@RestController
@RequestMapping("/checkTask/userInspect")
public class TUserInspectController extends BaseController
{
    @Autowired
    private ITUserInspectService tUserInspectService;

    /**
     * 查询【请填写功能名称】列表
     */
    //@PreAuthorize("@ss.hasPermi('checkTask:userInspect:list')")
    @GetMapping("/list")
    public TableDataInfo list(TUserInspect tUserInspect)
    {
        startPage();
        List<TUserInspect> list = tUserInspectService.selectTUserInspectList(tUserInspect);
        return getDataTable(list);
    }

    /**
     * 导出【请填写功能名称】列表
     */
    //@PreAuthorize("@ss.hasPermi('checkTask:userInspect:export')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TUserInspect tUserInspect)
    {
        List<TUserInspect> list = tUserInspectService.selectTUserInspectList(tUserInspect);
        ExcelUtil<TUserInspect> util = new ExcelUtil<TUserInspect>(TUserInspect.class);
        return util.exportExcel(list, "【请填写功能名称】数据");
    }

    /**
     * 获取【请填写功能名称】详细信息
     */
   // @PreAuthorize("@ss.hasPermi('checkTask:userInspect:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tUserInspectService.selectTUserInspectById(id));
    }

    /**
     * 新增【请填写功能名称】
     */
   // @PreAuthorize("@ss.hasPermi('checkTask:userInspect:add')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TUserInspect tUserInspect)
    {
        return toAjax(tUserInspectService.insertTUserInspect(tUserInspect));
    }

    /**
     * 修改【请填写功能名称】
     */
   // @PreAuthorize("@ss.hasPermi('checkTask:userInspect:edit')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TUserInspect tUserInspect)
    {
        return toAjax(tUserInspectService.updateTUserInspect(tUserInspect));
    }

    /**
     * 删除【请填写功能名称】
     */
    //@PreAuthorize("@ss.hasPermi('checkTask:userInspect:remove')")
    @Log(title = "【请填写功能名称】", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tUserInspectService.deleteTUserInspectByIds(ids));
    }
}
