import request from '@/utils/request'

// 查询特殊作业单签字列表
export function listSign(query) {
  return request({
    url: '/workPermit/sign/list',
    method: 'get',
    params: query
  })
}

//签字列表
export function signInfoList(query) {
  return request({
    url: '/workPermit/sign/signInfoList',
    method: 'get',
    params: query
  })
}

// 查询特殊作业单签字详细
export function getSign(id) {
  return request({
    url: '/workPermit/sign/' + id,
    method: 'get'
  })
}

// 新增特殊作业单签字
export function addSign(data) {
  return request({
    url: '/workPermit/sign',
    method: 'post',
    data: data
  })
}

// 修改特殊作业单签字
export function updateSign(data) {
  return request({
    url: '/workPermit/sign',
    method: 'put',
    data: data
  })
}

// 删除特殊作业单签字
export function delSign(id) {
  return request({
    url: '/workPermit/sign/' + id,
    method: 'delete'
  })
}

// 导出特殊作业单签字
export function exportSign(query) {
  return request({
    url: '/workPermit/sign/export',
    method: 'get',
    params: query
  })
}
