import request from '@/utils/request'

// 查询【请填写功能名称】列表
export function listInspect(query) {
  return request({
    url: '/checkTask/userInspect/list',
    method: 'get',
    params: query
  })
}

// 查询【请填写功能名称】详细
export function getInspect(id) {
  return request({
    url: '/checkTask/userInspect/' + id,
    method: 'get'
  })
}

// 新增【请填写功能名称】
export function addInspect(data) {
  return request({
    url: '/checkTask/userInspect',
    method: 'post',
    data: data
  })
}

// 修改【请填写功能名称】
export function updateInspect(data) {
  return request({
    url: '/checkTask/userInspect',
    method: 'put',
    data: data
  })
}

// 删除【请填写功能名称】
export function delInspect(id) {
  return request({
    url: '/checkTask/userInspect/' + id,
    method: 'delete'
  })
}

// 导出【请填写功能名称】
export function exportInspect(query) {
  return request({
    url: '/checkTask/userInspect/export',
    method: 'get',
    params: query
  })
}
