import request from '@/utils/request'

// 查询隐患状态记录列表
export function listStatus(query) {
  return request({
    url: '/danger/status/list',
    method: 'get',
    params: query
  })
}

//隐患变更信息
export function dangerStatusList(query) {
  return request({
    url: '/danger/status/dangerStatusList',
    method: 'get',
    params: query
  })
}

// 查询隐患状态记录详细
export function getStatus(id) {
  return request({
    url: '/danger/status/' + id,
    method: 'get'
  })
}

// 新增隐患状态记录
export function addStatus(data) {
  return request({
    url: '/danger/status',
    method: 'post',
    data: data
  })
}

// 修改隐患状态记录
export function updateStatus(data) {
  return request({
    url: '/danger/status',
    method: 'put',
    data: data
  })
}

// 删除隐患状态记录
export function delStatus(id) {
  return request({
    url: '/danger/status/' + id,
    method: 'delete'
  })
}

// 导出隐患状态记录
export function exportStatus(query) {
  return request({
    url: '/danger/status/export',
    method: 'get',
    params: query
  })
}
