import request from '@/utils/request'

// 查询安检隐患整改列表
export function listDanger(query) {
  return request({
    url: '/checkTask/danger/list',
    method: 'get',
    params: query
  })
}

// 查询安检隐患整改详细
export function getDanger(id) {
  return request({
    url: '/checkTask/danger/' + id,
    method: 'get'
  })
}

// 新增安检隐患整改
export function addDanger(data) {
  return request({
    url: '/checkTask/danger',
    method: 'post',
    data: data
  })
}

// 修改安检隐患整改
export function updateDanger(data) {
  return request({
    url: '/checkTask/danger',
    method: 'put',
    data: data
  })
}

// 删除安检隐患整改
export function delDanger(id) {
  return request({
    url: '/checkTask/danger/' + id,
    method: 'delete'
  })
}

// 导出安检隐患整改
export function exportDanger(query) {
  return request({
    url: '/checkTask/danger/export',
    method: 'get',
    params: query
  })
}

//游客权限操作
export function dangerDataPermission(query) {
  return request({
    url: '/checkTask/danger/dangerDataPermission',
    method: 'get',
    params: query
  })
}
