import request from '@/utils/request'

// 查询管线打卡点列表
export function listPoint(query) {
  return request({
    url: '/baseInfo/point/list',
    method: 'get',
    params: query
  })
}

export function pointInfoList(query) {
  return request({
    url: '/baseInfo/point/pointInfoList',
    method: 'get',
    params: query
  })
}

// 查询管线打卡点详细
export function getPoint(id) {
  return request({
    url: '/baseInfo/point/' + id,
    method: 'get'
  })
}

// 新增管线打卡点
export function addPoint(data) {
  return request({
    url: '/baseInfo/point',
    method: 'post',
    data: data
  })
}

// 修改管线打卡点
export function updatePoint(data) {
  return request({
    url: '/baseInfo/point',
    method: 'put',
    data: data
  })
}

// 删除管线打卡点
export function delPoint(id) {
  return request({
    url: '/baseInfo/point/' + id,
    method: 'delete'
  })
}

// 导出管线打卡点
export function exportPoint(query) {
  return request({
    url: '/baseInfo/point/export',
    method: 'get',
    params: query
  })
}

export function selectPointDetail(query) {
  return request({
    url: '/baseInfo/point/selectPointDetail',
    method: 'get',
    params: query
  })
}
