package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TMemoryLogMapper;
import com.zehong.system.domain.TMemoryLog;
import com.zehong.system.service.ITMemoryLogService;

/**
 * 内存报警日志Service业务层处理
 * 
 * @author zehong
 * @date 2024-05-08
 */
@Service
public class TMemoryLogServiceImpl implements ITMemoryLogService 
{
    @Autowired
    private TMemoryLogMapper tMemoryLogMapper;

    /**
     * 查询内存报警日志
     * 
     * @param id 内存报警日志ID
     * @return 内存报警日志
     */
    @Override
    public TMemoryLog selectTMemoryLogById(Long id)
    {
        return tMemoryLogMapper.selectTMemoryLogById(id);
    }

    /**
     * 查询内存报警日志列表
     * 
     * @param tMemoryLog 内存报警日志
     * @return 内存报警日志
     */
    @Override
    public List<TMemoryLog> selectTMemoryLogList(TMemoryLog tMemoryLog)
    {
        return tMemoryLogMapper.selectTMemoryLogList(tMemoryLog);
    }

    /**
     * 新增内存报警日志
     * 
     * @param tMemoryLog 内存报警日志
     * @return 结果
     */
    @Override
    public int insertTMemoryLog(TMemoryLog tMemoryLog)
    {
        tMemoryLog.setCreateTime(DateUtils.getNowDate());
        return tMemoryLogMapper.insertTMemoryLog(tMemoryLog);
    }

    /**
     * 修改内存报警日志
     * 
     * @param tMemoryLog 内存报警日志
     * @return 结果
     */
    @Override
    public int updateTMemoryLog(TMemoryLog tMemoryLog)
    {
        return tMemoryLogMapper.updateTMemoryLog(tMemoryLog);
    }

    /**
     * 批量删除内存报警日志
     * 
     * @param ids 需要删除的内存报警日志ID
     * @return 结果
     */
    @Override
    public int deleteTMemoryLogByIds(Long[] ids)
    {
        return tMemoryLogMapper.deleteTMemoryLogByIds(ids);
    }

    /**
     * 删除内存报警日志信息
     * 
     * @param id 内存报警日志ID
     * @return 结果
     */
    @Override
    public int deleteTMemoryLogById(Long id)
    {
        return tMemoryLogMapper.deleteTMemoryLogById(id);
    }
}
