package com.zehong.system.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TBusinessMapper;
import com.zehong.system.domain.TBusiness;
import com.zehong.system.service.ITBusinessService;

/**
 * 工商业用户Service业务层处理
 * 
 * @author zehong
 * @date 2023-11-03
 */
@Service
public class TBusinessServiceImpl implements ITBusinessService 
{
    @Autowired
    private TBusinessMapper tBusinessMapper;

    /**
     * 查询工商业用户
     * 
     * @param id 工商业用户ID
     * @return 工商业用户
     */
    @Override
    public TBusiness selectTBusinessById(Long id)
    {
        return tBusinessMapper.selectTBusinessById(id);
    }

    /**
     * 查询工商业用户列表
     * 
     * @param tBusiness 工商业用户
     * @return 工商业用户
     */
    @Override
    public List<TBusiness> selectTBusinessList(TBusiness tBusiness)
    {
        return tBusinessMapper.selectTBusinessList(tBusiness);
    }

    /**
     * 新增工商业用户
     * 
     * @param tBusiness 工商业用户
     * @return 结果
     */
    @Override
    public int insertTBusiness(TBusiness tBusiness)
    {
        return tBusinessMapper.insertTBusiness(tBusiness);
    }

    /**
     * 修改工商业用户
     * 
     * @param tBusiness 工商业用户
     * @return 结果
     */
    @Override
    public int updateTBusiness(TBusiness tBusiness)
    {
        return tBusinessMapper.updateTBusiness(tBusiness);
    }

    /**
     * 批量删除工商业用户
     * 
     * @param ids 需要删除的工商业用户ID
     * @return 结果
     */
    @Override
    public int deleteTBusinessByIds(Long[] ids)
    {
        return tBusinessMapper.deleteTBusinessByIds(ids);
    }

    /**
     * 删除工商业用户信息
     * 
     * @param id 工商业用户ID
     * @return 结果
     */
    @Override
    public int deleteTBusinessById(Long id)
    {
        return tBusinessMapper.deleteTBusinessById(id);
    }
}
