package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TTaskRelationInfo;

/**
 * 安检任务关联信息Mapper接口
 * 
 * @author zehong
 * @date 2025-12-08
 */
public interface TTaskRelationInfoMapper 
{
    /**
     * 查询安检任务关联信息
     * 
     * @param id 安检任务关联信息ID
     * @return 安检任务关联信息
     */
    public TTaskRelationInfo selectTTaskRelationInfoById(Long id);

    /**
     * 查询安检任务关联信息列表
     * 
     * @param tTaskRelationInfo 安检任务关联信息
     * @return 安检任务关联信息集合
     */
    public List<TTaskRelationInfo> selectTTaskRelationInfoList(TTaskRelationInfo tTaskRelationInfo);

    /**
     * 新增安检任务关联信息
     * 
     * @param tTaskRelationInfo 安检任务关联信息
     * @return 结果
     */
    public int insertTTaskRelationInfo(TTaskRelationInfo tTaskRelationInfo);

    /**
     * 修改安检任务关联信息
     * 
     * @param tTaskRelationInfo 安检任务关联信息
     * @return 结果
     */
    public int updateTTaskRelationInfo(TTaskRelationInfo tTaskRelationInfo);

    /**
     * 删除安检任务关联信息
     * 
     * @param id 安检任务关联信息ID
     * @return 结果
     */
    public int deleteTTaskRelationInfoById(Long id);

    /**
     * 根据任务删除关联关系
     * @param taskId 任务主键
     * @return
     */
    int deleteTTaskRelationInfoByTaskId(Long taskId);

    /**
     * 批量删除安检任务关联信息
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTTaskRelationInfoByIds(Long[] ids);
}
