package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 应急联系人对象 t_urgent_contacts
 * 
 * @author zehong
 * @date 2023-12-19
 */
public class TUrgentContacts extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 姓名 */
    @Excel(name = "姓名")
    private String username;

    /** 电话 */
    @Excel(name = "电话")
    private String phone;

    /** 所在公司 */
    @Excel(name = "所在公司")
    private String company;

    /** 所在部门 */
    @Excel(name = "所在部门")
    private String dept;

    /** 单位职务 */
    @Excel(name = "单位职务")
    private String job;

    /** 应急职务 */
    @Excel(name = "应急职务")
    private String urgentJob;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setUsername(String username) 
    {
        this.username = username;
    }

    public String getUsername() 
    {
        return username;
    }
    public void setPhone(String phone) 
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }
    public void setCompany(String company) 
    {
        this.company = company;
    }

    public String getCompany() 
    {
        return company;
    }
    public void setDept(String dept) 
    {
        this.dept = dept;
    }

    public String getDept() 
    {
        return dept;
    }
    public void setJob(String job) 
    {
        this.job = job;
    }

    public String getJob() 
    {
        return job;
    }
    public void setUrgentJob(String urgentJob) 
    {
        this.urgentJob = urgentJob;
    }

    public String getUrgentJob() 
    {
        return urgentJob;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("username", getUsername())
            .append("phone", getPhone())
            .append("company", getCompany())
            .append("dept", getDept())
            .append("job", getJob())
            .append("urgentJob", getUrgentJob())
            .append("remark", getRemark())
            .append("createTime", getCreateTime())
            .toString();
    }
}
