package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 安检单导出对象 t_task_inspect_export
 *
 * @author zehong
 * @date 2024-10-16
 */
public class TTaskInspectExport extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long exportId;

    /** 任务主键 */
    @Excel(name = "任务主键")
    private Long taskId;

    /** 安检主键 */
    @Excel(name = "安检主键")
    private Long inspectId;

    /** 安检人主键 */
    @Excel(name = "安检人主键")
    private Long memberId;

    /** 用户主键 */
    @Excel(name = "用户主键")
    private Long receiveId;

    /** 安检时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "安检时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date inspectTime;

    /** 用户类型，1是居民，2是工商户，3是工业 */
    @Excel(name = "用户类型，1是居民，2是工商户，3是工业")
    private Long type;

    /** 导出表名 */
    @Excel(name = "导出表名")
    private String fileName;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date inspectBeginTime;

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date inspectEndTime;

    private String username;

    private String usernum;

    private Long village;

    private String nickName;

    private String companyName;

    public void setExportId(Long exportId)
    {
        this.exportId = exportId;
    }

    public Long getExportId()
    {
        return exportId;
    }
    public void setTaskId(Long taskId)
    {
        this.taskId = taskId;
    }

    public Long getTaskId()
    {
        return taskId;
    }
    public void setInspectId(Long inspectId)
    {
        this.inspectId = inspectId;
    }

    public Long getInspectId()
    {
        return inspectId;
    }
    public void setMemberId(Long memberId)
    {
        this.memberId = memberId;
    }

    public Long getMemberId()
    {
        return memberId;
    }
    public void setReceiveId(Long receiveId)
    {
        this.receiveId = receiveId;
    }

    public Long getReceiveId()
    {
        return receiveId;
    }
    public void setInspectTime(Date inspectTime)
    {
        this.inspectTime = inspectTime;
    }

    public Date getInspectTime()
    {
        return inspectTime;
    }
    public void setType(Long type)
    {
        this.type = type;
    }

    public Long getType()
    {
        return type;
    }

    public void setFileName(String fileName)
    {
        this.fileName = fileName;
    }

    public String getFileName()
    {
        return fileName;
    }


    public Date getInspectBeginTime() {
        return inspectBeginTime;
    }

    public void setInspectBeginTime(Date inspectBeginTime) {
        this.inspectBeginTime = inspectBeginTime;
    }

    public Date getInspectEndTime() {
        return inspectEndTime;
    }

    public void setInspectEndTime(Date inspectEndTime) {
        this.inspectEndTime = inspectEndTime;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsernum() {
        return usernum;
    }

    public void setUsernum(String usernum) {
        this.usernum = usernum;
    }

    public Long getVillage() {
        return village;
    }

    public void setVillage(Long village) {
        this.village = village;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
                .append("exportId", getExportId())
                .append("taskId", getTaskId())
                .append("inspectId", getInspectId())
                .append("memberId", getMemberId())
                .append("receiveId", getReceiveId())
                .append("inspectTime", getInspectTime())
                .append("type", getType())
                .append("fileName", getFileName())
                .append("createTime", getCreateTime())
                .append("remark", getRemark())
                .toString();
    }
}