package com.zehong.system.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 应急处置步骤对象 t_emergency_dispose_step
 * 
 * @author zehong
 * @date 2024-09-07
 */
public class TEmergencyDisposeStep extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 应急处置步骤主键 */
    private Long stepId;

    /** 应急响应主键 */
    @Excel(name = "应急响应主键")
    private Long responseId;

    /** 处置内容 */
    @Excel(name = "处置内容")
    private String disposeContent;

    /** 处置时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "处置时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date disposeTime;

    /** 处置人 */
    private Long disposer;

    @Excel(name = "处置人")
    private String nickName;

    public void setStepId(Long stepId)
    {
        this.stepId = stepId;
    }

    public Long getStepId() 
    {
        return stepId;
    }
    public void setResponseId(Long responseId) 
    {
        this.responseId = responseId;
    }

    public Long getResponseId() 
    {
        return responseId;
    }
    public void setDisposeContent(String disposeContent) 
    {
        this.disposeContent = disposeContent;
    }

    public String getDisposeContent() 
    {
        return disposeContent;
    }
    public void setDisposeTime(Date disposeTime) 
    {
        this.disposeTime = disposeTime;
    }

    public Date getDisposeTime() 
    {
        return disposeTime;
    }
    public void setDisposer(Long disposer)
    {
        this.disposer = disposer;
    }

    public Long getDisposer()
    {
        return disposer;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("stepId", getStepId())
            .append("responseId", getResponseId())
            .append("disposeContent", getDisposeContent())
            .append("disposeTime", getDisposeTime())
            .append("disposer", getDisposer())
            .toString();
    }
}
