package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 隐患状态记录对象 t_danger_status
 * 
 * @author zehong
 * @date 2023-12-01
 */
public class TDangerStatus extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 隐患id */
    @Excel(name = "隐患id")
    private Long dangerId;

    /** 隐患状态，0待处理，1拒绝整改，2待复核，3已处理 */
    @Excel(name = "隐患状态，0待处理，1拒绝整改，2待复核，3已处理")
    private Integer status;

    /** 操作时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "操作时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date optime;

    /** 操作人 */
    @Excel(name = "操作人")
    private Long adminId;

    private String operator;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setDangerId(Long dangerId) 
    {
        this.dangerId = dangerId;
    }

    public Long getDangerId() 
    {
        return dangerId;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }
    public void setOptime(Date optime) 
    {
        this.optime = optime;
    }

    public Date getOptime() 
    {
        return optime;
    }
    public void setAdminId(Long adminId) 
    {
        this.adminId = adminId;
    }

    public Long getAdminId() 
    {
        return adminId;
    }

    public String getOperator() {
        return operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("dangerId", getDangerId())
            .append("status", getStatus())
            .append("optime", getOptime())
            .append("adminId", getAdminId())
            .toString();
    }
}
