package com.zehong.web.controller.emergency;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEmergencyAlarmNotifyRecord;
import com.zehong.system.service.ITEmergencyAlarmNotifyRecordService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 应急报警通知记录Controller
 * 
 * @author zehong
 * @date 2024-12-10
 */
@RestController
@RequestMapping("/emergency/notify")
public class TEmergencyAlarmNotifyRecordController extends BaseController
{
    @Autowired
    private ITEmergencyAlarmNotifyRecordService tEmergencyAlarmNotifyRecordService;

    /**
     * 查询应急报警通知记录列表
     */
   // @PreAuthorize("@ss.hasPermi('system:record:list')")
    @GetMapping("/list")
    public TableDataInfo list(TEmergencyAlarmNotifyRecord tEmergencyAlarmNotifyRecord)
    {
        startPage();
        List<TEmergencyAlarmNotifyRecord> list = tEmergencyAlarmNotifyRecordService.selectTEmergencyAlarmNotifyRecordList(tEmergencyAlarmNotifyRecord);
        return getDataTable(list);
    }

    /**
     * 导出应急报警通知记录列表
     */
   // @PreAuthorize("@ss.hasPermi('system:record:export')")
    @Log(title = "应急报警通知记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEmergencyAlarmNotifyRecord tEmergencyAlarmNotifyRecord)
    {
        List<TEmergencyAlarmNotifyRecord> list = tEmergencyAlarmNotifyRecordService.selectTEmergencyAlarmNotifyRecordList(tEmergencyAlarmNotifyRecord);
        ExcelUtil<TEmergencyAlarmNotifyRecord> util = new ExcelUtil<TEmergencyAlarmNotifyRecord>(TEmergencyAlarmNotifyRecord.class);
        return util.exportExcel(list, "应急报警通知记录数据");
    }

    /**
     * 获取应急报警通知记录详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:record:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tEmergencyAlarmNotifyRecordService.selectTEmergencyAlarmNotifyRecordById(id));
    }

    /**
     * 新增应急报警通知记录
     */
    //@PreAuthorize("@ss.hasPermi('system:record:add')")
    @Log(title = "应急报警通知记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEmergencyAlarmNotifyRecord tEmergencyAlarmNotifyRecord)
    {
        return toAjax(tEmergencyAlarmNotifyRecordService.insertTEmergencyAlarmNotifyRecord(tEmergencyAlarmNotifyRecord));
    }

    /**
     * 修改应急报警通知记录
     */
    //@PreAuthorize("@ss.hasPermi('system:record:edit')")
    @Log(title = "应急报警通知记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEmergencyAlarmNotifyRecord tEmergencyAlarmNotifyRecord)
    {
        return toAjax(tEmergencyAlarmNotifyRecordService.updateTEmergencyAlarmNotifyRecord(tEmergencyAlarmNotifyRecord));
    }

    /**
     * 删除应急报警通知记录
     */
   // @PreAuthorize("@ss.hasPermi('system:record:remove')")
    @Log(title = "应急报警通知记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tEmergencyAlarmNotifyRecordService.deleteTEmergencyAlarmNotifyRecordByIds(ids));
    }

    /**
     * 发送通知
     * @param alarmId 报警主键
     * @return
     */
    @GetMapping(value = "/alarmNotify")
    public AjaxResult alarmNotify(@RequestParam(value="alarmId") Long alarmId) {
        tEmergencyAlarmNotifyRecordService.alarmNotify(alarmId);
        return AjaxResult.success();
    }
}
