package com.zehong.web.controller.checktask;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TTaskRelationInfo;
import com.zehong.system.service.ITTaskRelationInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 安检任务关联信息Controller
 * 
 * @author zehong
 * @date 2025-12-08
 */
@RestController
@RequestMapping("/checkTask/relation")
public class TTaskRelationInfoController extends BaseController
{
    @Autowired
    private ITTaskRelationInfoService tTaskRelationInfoService;

    /**
     * 查询安检任务关联信息列表
     */
    @PreAuthorize("@ss.hasPermi('checkTask:relation:list')")
    @GetMapping("/list")
    public TableDataInfo list(TTaskRelationInfo tTaskRelationInfo)
    {
        startPage();
        List<TTaskRelationInfo> list = tTaskRelationInfoService.selectTTaskRelationInfoList(tTaskRelationInfo);
        return getDataTable(list);
    }

    /**
     * 导出安检任务关联信息列表
     */
    @PreAuthorize("@ss.hasPermi('checkTask:relation:export')")
    @Log(title = "安检任务关联信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TTaskRelationInfo tTaskRelationInfo)
    {
        List<TTaskRelationInfo> list = tTaskRelationInfoService.selectTTaskRelationInfoList(tTaskRelationInfo);
        ExcelUtil<TTaskRelationInfo> util = new ExcelUtil<TTaskRelationInfo>(TTaskRelationInfo.class);
        return util.exportExcel(list, "安检任务关联信息数据");
    }

    /**
     * 获取安检任务关联信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('checkTask:relation:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tTaskRelationInfoService.selectTTaskRelationInfoById(id));
    }

    /**
     * 新增安检任务关联信息
     */
    @PreAuthorize("@ss.hasPermi('checkTask:relation:add')")
    @Log(title = "安检任务关联信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TTaskRelationInfo tTaskRelationInfo)
    {
        return toAjax(tTaskRelationInfoService.insertTTaskRelationInfo(tTaskRelationInfo));
    }

    /**
     * 修改安检任务关联信息
     */
    @PreAuthorize("@ss.hasPermi('checkTask:relation:edit')")
    @Log(title = "安检任务关联信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TTaskRelationInfo tTaskRelationInfo)
    {
        return toAjax(tTaskRelationInfoService.updateTTaskRelationInfo(tTaskRelationInfo));
    }

    /**
     * 删除安检任务关联信息
     */
    @PreAuthorize("@ss.hasPermi('checkTask:relation:remove')")
    @Log(title = "安检任务关联信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tTaskRelationInfoService.deleteTTaskRelationInfoByIds(ids));
    }
}
