package com.zehong.system.service.impl;

import java.util.List;
import com.zehong.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TTaskRelationInfoMapper;
import com.zehong.system.domain.TTaskRelationInfo;
import com.zehong.system.service.ITTaskRelationInfoService;

/**
 * 安检任务关联信息Service业务层处理
 * 
 * @author zehong
 * @date 2025-12-08
 */
@Service
public class TTaskRelationInfoServiceImpl implements ITTaskRelationInfoService 
{
    @Autowired
    private TTaskRelationInfoMapper tTaskRelationInfoMapper;

    /**
     * 查询安检任务关联信息
     * 
     * @param id 安检任务关联信息ID
     * @return 安检任务关联信息
     */
    @Override
    public TTaskRelationInfo selectTTaskRelationInfoById(Long id)
    {
        return tTaskRelationInfoMapper.selectTTaskRelationInfoById(id);
    }

    /**
     * 查询安检任务关联信息列表
     * 
     * @param tTaskRelationInfo 安检任务关联信息
     * @return 安检任务关联信息
     */
    @Override
    public List<TTaskRelationInfo> selectTTaskRelationInfoList(TTaskRelationInfo tTaskRelationInfo)
    {
        return tTaskRelationInfoMapper.selectTTaskRelationInfoList(tTaskRelationInfo);
    }

    /**
     * 新增安检任务关联信息
     * 
     * @param tTaskRelationInfo 安检任务关联信息
     * @return 结果
     */
    @Override
    public int insertTTaskRelationInfo(TTaskRelationInfo tTaskRelationInfo)
    {
        tTaskRelationInfo.setCreateTime(DateUtils.getNowDate());
        return tTaskRelationInfoMapper.insertTTaskRelationInfo(tTaskRelationInfo);
    }

    /**
     * 修改安检任务关联信息
     * 
     * @param tTaskRelationInfo 安检任务关联信息
     * @return 结果
     */
    @Override
    public int updateTTaskRelationInfo(TTaskRelationInfo tTaskRelationInfo)
    {
        tTaskRelationInfo.setUpdateTime(DateUtils.getNowDate());
        return tTaskRelationInfoMapper.updateTTaskRelationInfo(tTaskRelationInfo);
    }

    /**
     * 批量删除安检任务关联信息
     * 
     * @param ids 需要删除的安检任务关联信息ID
     * @return 结果
     */
    @Override
    public int deleteTTaskRelationInfoByIds(Long[] ids)
    {
        return tTaskRelationInfoMapper.deleteTTaskRelationInfoByIds(ids);
    }

    /**
     * 删除安检任务关联信息信息
     * 
     * @param id 安检任务关联信息ID
     * @return 结果
     */
    @Override
    public int deleteTTaskRelationInfoById(Long id)
    {
        return tTaskRelationInfoMapper.deleteTTaskRelationInfoById(id);
    }
}
