package com.zehong.system.service.impl;

import java.text.DecimalFormat;
import java.text.Format;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.zehong.common.utils.DateUtils;
import com.zehong.system.domain.TSpecialDocumentSign;
import com.zehong.system.mapper.TSpecialDocumentSignMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSpecialDocumentMapper;
import com.zehong.system.domain.TSpecialDocument;
import com.zehong.system.service.ITSpecialDocumentService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 特殊作业单Service业务层处理
 * 
 * @author zehong
 * @date 2023-12-04
 */
@Service
public class TSpecialDocumentServiceImpl implements ITSpecialDocumentService 
{
    @Autowired
    private TSpecialDocumentMapper tSpecialDocumentMapper;
    @Autowired
    private TSpecialDocumentSignMapper tSpecialDocumentSignMapper;
    private String[] str = {"火","土","断","高","临","盲","限","吊"};

    /**
     * 查询特殊作业单
     * 
     * @param id 特殊作业单ID
     * @return 特殊作业单
     */
    @Override
    public TSpecialDocument selectTSpecialDocumentById(Long id)
    {
        return tSpecialDocumentMapper.selectTSpecialDocumentById(id);
    }

    /**
     * 查询特殊作业单列表
     * 
     * @param tSpecialDocument 特殊作业单
     * @return 特殊作业单
     */
    @Override
    public List<TSpecialDocument> selectTSpecialDocumentList(TSpecialDocument tSpecialDocument)
    {
        return tSpecialDocumentMapper.selectTSpecialDocumentList(tSpecialDocument);
    }

    /**
     * 小程序特殊作业证列表
     * @param tSpecialDocument
     * @return
     */
    public List<TSpecialDocument> selectSpecialListwx(TSpecialDocument tSpecialDocument)
    {
        return tSpecialDocumentMapper.selectSpecialListwx(tSpecialDocument);
    }

    /**
     * 新增特殊作业单
     * 
     * @param tSpecialDocument 特殊作业单
     * @return 结果
     */
    @Override
    public int insertTSpecialDocument(TSpecialDocument tSpecialDocument)
    {
        synchronized (this){
            tSpecialDocument.setCreateTime(DateUtils.getNowDate());
            tSpecialDocument.setDocumentNum(getNum(tSpecialDocument.getDocumentType()));
            int a =tSpecialDocumentMapper.insertTSpecialDocument(tSpecialDocument);
            if(tSpecialDocument.getSignlist()!=null){
                tSpecialDocumentSignMapper.deleteBySpecialId(tSpecialDocument.getId());
                List<Map<String,Object>> list = (List<Map<String,Object>>)JSON.parse(tSpecialDocument.getSignlist());
                for(Map<String,Object> map : list){
                    TSpecialDocumentSign sign = new TSpecialDocumentSign();
                    sign.setTurnSign((Integer) map.get("sort")>0?0:1);
                    sign.setSort((Integer)map.get("sort"));
                    sign.setSpecialId(tSpecialDocument.getId());
                    sign.setUserId(Long.valueOf((Integer)map.get("userId")));
                    tSpecialDocumentSignMapper.insertTSpecialDocumentSign(sign);
                }
            }
            return a;
        }
    }

    /**
     * 修改特殊作业单
     * 
     * @param tSpecialDocument 特殊作业单
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateTSpecialDocument(TSpecialDocument tSpecialDocument)
    {
        if(tSpecialDocument.getDocumentType()==null){
            return tSpecialDocumentMapper.updateTSpecialDocument(tSpecialDocument);
        }
        //动火作业证、受限空间作业证分析时间
        if((tSpecialDocument.getDocumentType()==1||tSpecialDocument.getDocumentType()==7)&&tSpecialDocument.getStatus()==2){
            tSpecialDocument.setAnalysisTime(new Date());
        }
        if(tSpecialDocument.getSignlist()!=null){
            tSpecialDocumentSignMapper.deleteBySpecialId(tSpecialDocument.getId());
            List<Map<String,Object>> list = (List<Map<String,Object>>)JSON.parse(tSpecialDocument.getSignlist());
            for(Map<String,Object> map : list){
                TSpecialDocumentSign sign = new TSpecialDocumentSign();
                sign.setTurnSign((Integer) map.get("sort")>0?0:1);
                sign.setSort((Integer)map.get("sort"));
                sign.setSpecialId(tSpecialDocument.getId());
                sign.setUserId(Long.valueOf((Integer)map.get("userId")));
                tSpecialDocumentSignMapper.insertTSpecialDocumentSign(sign);
            }
        }
        return tSpecialDocumentMapper.updateTSpecialDocument(tSpecialDocument);
    }

    /**
     * 批量删除特殊作业单
     * 
     * @param ids 需要删除的特殊作业单ID
     * @return 结果
     */
    @Override
    public int deleteTSpecialDocumentByIds(Long[] ids)
    {
        return tSpecialDocumentMapper.deleteTSpecialDocumentByIds(ids);
    }

    /**
     * 删除特殊作业单信息
     * 
     * @param id 特殊作业单ID
     * @return 结果
     */
    @Override
    public int deleteTSpecialDocumentById(Long id)
    {
        return tSpecialDocumentMapper.deleteTSpecialDocumentById(id);
    }

    /**
     * 获取作业证编号
     * @return
     */
    public String getNum(Integer type){
        //获取当前年限
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(Calendar.YEAR);
        //生成编号格式
        String cardNum =  "TH"+year+'-'+str[type-1]+'-';
        //获取最新记录
        TSpecialDocument td = tSpecialDocumentMapper.selectNew(type);
        if(td!=null && td.getDocumentNum()!=null){
            if(td.getDocumentNum().length()>8 && td.getDocumentNum().substring(2,6).equals(String.valueOf(year))){
                String num = td.getDocumentNum().split("-")[2];
                //String ee ="001";
                int ii = Integer.valueOf(num).intValue()+1;
                Format f1 = new DecimalFormat("000");
                f1.format(ii);
                cardNum = cardNum +f1.format(ii);
            }else{
                cardNum = cardNum +"001";
            }

        }else{
            cardNum = cardNum +"001";
        }

        return cardNum;
    }
}
