package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TPipeUser;
import com.zehong.system.mapper.TPipeUserMapper;
import com.zehong.system.service.ITPipeUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 管线巡线人员分配Service业务层处理
 * 
 * @author zehong
 * @date 2023-11-16
 */
@Service
public class TPipeUserServiceImpl implements ITPipeUserService 
{
    @Autowired
    private TPipeUserMapper tPipeUserMapper;

    /**
     * 查询管线巡线人员分配
     * 
     * @param id 管线巡线人员分配ID
     * @return 管线巡线人员分配
     */
    @Override
    public TPipeUser selectTPipeUserById(Long id)
    {
        return tPipeUserMapper.selectTPipeUserById(id);
    }

    /**
     * 查询管线巡线人员分配列表
     * 
     * @param tPipeUser 管线巡线人员分配
     * @return 管线巡线人员分配
     */
    @Override
    public List<TPipeUser> selectTPipeUserList(TPipeUser tPipeUser)
    {
        return tPipeUserMapper.selectTPipeUserList(tPipeUser);
    }

    /**
     * 新增管线巡线人员分配
     * 
     * @param tPipeUser 管线巡线人员分配
     * @return 结果
     */
    @Override
    public int insertTPipeUser(TPipeUser tPipeUser)
    {
        tPipeUser.setCreateTime(DateUtils.getNowDate());
        tPipeUser.setAdminId(SecurityUtils.getLoginUser().getUser().getUserId());
        return tPipeUserMapper.insertTPipeUser(tPipeUser);
    }

    /**
     * 修改管线巡线人员分配
     * 
     * @param tPipeUser 管线巡线人员分配
     * @return 结果
     */
    @Override
    public int updateTPipeUser(TPipeUser tPipeUser)
    {
        return tPipeUserMapper.updateTPipeUser(tPipeUser);
    }

    /**
     * 批量删除管线巡线人员分配
     * 
     * @param ids 需要删除的管线巡线人员分配ID
     * @return 结果
     */
    @Override
    public int deleteTPipeUserByIds(Long[] ids)
    {
        return tPipeUserMapper.deleteTPipeUserByIds(ids);
    }

    /**
     * 删除管线巡线人员分配信息
     * 
     * @param id 管线巡线人员分配ID
     * @return 结果
     */
    @Override
    public int deleteTPipeUserById(Long id)
    {
        return tPipeUserMapper.deleteTPipeUserById(id);
    }


    /**
     * 根据用户和管道主键删除
     * @param userId 用户主键
     * @param pipeId 管道主键
     * @return
     */
    @Override
    public int deleteTPipeUserByUserIdAndPipeId(Long userId,Long pipeId){
        return tPipeUserMapper.deleteTPipeUserByUserIdAndPipeId(userId,pipeId);
    }
}
