package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TSiteTask;

/**
 * 场站巡检任务Service接口
 * 
 * @author zehong
 * @date 2023-12-15
 */
public interface ITSiteTaskService 
{
    /**
     * 查询场站巡检任务
     * 
     * @param id 场站巡检任务ID
     * @return 场站巡检任务
     */
    public TSiteTask selectTSiteTaskById(Long id);

    /**
     * 查询场站巡检任务列表
     * 
     * @param tSiteTask 场站巡检任务
     * @return 场站巡检任务集合
     */
    public List<TSiteTask> selectTSiteTaskList(TSiteTask tSiteTask);

    /**
     * 小程序任务列表
     * @param tSiteTask
     * @return
     */
    public List<TSiteTask> selectTSiteTaskwxList(TSiteTask tSiteTask);

    /**
     * 新增场站巡检任务
     * 
     * @param tSiteTask 场站巡检任务
     * @return 结果
     */
    public int insertTSiteTask(TSiteTask tSiteTask);

    /**
     * 修改场站巡检任务
     * 
     * @param tSiteTask 场站巡检任务
     * @return 结果
     */
    public int updateTSiteTask(TSiteTask tSiteTask);

    /**
     * 批量删除场站巡检任务
     * 
     * @param ids 需要删除的场站巡检任务ID
     * @return 结果
     */
    public int deleteTSiteTaskByIds(Long[] ids);

    /**
     * 删除场站巡检任务信息
     * 
     * @param id 场站巡检任务ID
     * @return 结果
     */
    public int deleteTSiteTaskById(Long id);
}
