package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TPipeInfo;

/**
 * 管道信息Service接口
 * 
 * @author zehong
 * @date 2023-11-02
 */
public interface ITPipeInfoService 
{
    /**
     * 查询管道信息
     * 
     * @param pipeId 管道信息ID
     * @return 管道信息
     */
    public TPipeInfo selectTPipeInfoById(Long pipeId);

    /**
     * 查询管道信息列表
     * 
     * @param tPipeInfo 管道信息
     * @return 管道信息集合
     */
    public List<TPipeInfo> selectTPipeInfoList(TPipeInfo tPipeInfo);

    /**
     * 新增管道信息
     * 
     * @param tPipeInfo 管道信息
     * @return 结果
     */
    public int insertTPipeInfo(TPipeInfo tPipeInfo);

    /**
     * 修改管道信息
     * 
     * @param tPipeInfo 管道信息
     * @return 结果
     */
    public int updateTPipeInfo(TPipeInfo tPipeInfo);

    /**
     * 批量删除管道信息
     * 
     * @param pipeIds 需要删除的管道信息ID
     * @return 结果
     */
    public int deleteTPipeInfoByIds(Long[] pipeIds);

    /**
     * 删除管道信息信息
     * 
     * @param pipeId 管道信息ID
     * @return 结果
     */
    public int deleteTPipeInfoById(Long pipeId);

    /**
     * 根据巡线查询管道信息
     * @param tPipeInfo 管道信息
     * @return
     */
    List<TPipeInfo> selectPipeInfoByUser(TPipeInfo tPipeInfo);
}
