package com.zehong.web.controller.warning;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TWarningInfo;
import com.zehong.system.service.ITWarningInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 警告提醒Controller
 * 
 * @author zehong
 * @date 2024-09-05
 */
@RestController
@RequestMapping("/warning/info")
public class TWarningInfoController extends BaseController
{
    @Autowired
    private ITWarningInfoService tWarningInfoService;

    /**
     * 查询警告提醒列表
     */
    @PreAuthorize("@ss.hasPermi('warning:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(TWarningInfo tWarningInfo)
    {
        startPage();
        List<TWarningInfo> list = tWarningInfoService.selectTWarningInfoList(tWarningInfo);
        return getDataTable(list);
    }

    /**
     * 导出警告提醒列表
     */
    @PreAuthorize("@ss.hasPermi('warning:info:export')")
    @Log(title = "警告提醒", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TWarningInfo tWarningInfo)
    {
        List<TWarningInfo> list = tWarningInfoService.selectTWarningInfoList(tWarningInfo);
        ExcelUtil<TWarningInfo> util = new ExcelUtil<TWarningInfo>(TWarningInfo.class);
        return util.exportExcel(list, "警告提醒数据");
    }

    /**
     * 获取警告提醒详细信息
     */
    @PreAuthorize("@ss.hasPermi('warning:info:query')")
    @GetMapping(value = "/{warningId}")
    public AjaxResult getInfo(@PathVariable("warningId") Long warningId)
    {
        return AjaxResult.success(tWarningInfoService.selectTWarningInfoById(warningId));
    }

    /**
     * 新增警告提醒
     */
    @PreAuthorize("@ss.hasPermi('warning:info:add')")
    @Log(title = "警告提醒", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TWarningInfo tWarningInfo)
    {
        return toAjax(tWarningInfoService.insertTWarningInfo(tWarningInfo));
    }

    /**
     * 修改警告提醒
     */
    @PreAuthorize("@ss.hasPermi('warning:info:edit')")
    @Log(title = "警告提醒", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TWarningInfo tWarningInfo)
    {
        return toAjax(tWarningInfoService.updateTWarningInfo(tWarningInfo));
    }

    /**
     * 删除警告提醒
     */
    @PreAuthorize("@ss.hasPermi('warning:info:remove')")
    @Log(title = "警告提醒", businessType = BusinessType.DELETE)
	@DeleteMapping("/{warningIds}")
    public AjaxResult remove(@PathVariable Long[] warningIds)
    {
        return toAjax(tWarningInfoService.deleteTWarningInfoByIds(warningIds));
    }

    /**
     * 解除警报
     * @param warningId 警报主键
     * @return
     */
    @GetMapping("/freeWarningInfo")
    public AjaxResult freeWarningInfo(Long warningId){
        return toAjax(tWarningInfoService.freeWarningInfo(warningId));
    }
}
