package com.zehong.web.controller.group;

import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.core.page.TableDataInfo;
import com.zehong.common.enums.BusinessType;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.system.domain.TGroupMemberInfo;
import com.zehong.system.service.ITGroupMemberInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Map;

/**
 * 组内成员信息Controller
 * 
 * @author zehong
 * @date 2025-12-05
 */
@RestController
@RequestMapping("/group/member")
public class TGroupMemberInfoController extends BaseController
{
    @Autowired
    private ITGroupMemberInfoService tGroupMemberInfoService;

    /**
     * 查询组内成员信息列表
     */
    @PreAuthorize("@ss.hasPermi('group:member:list')")
    @GetMapping("/list")
    public TableDataInfo list(TGroupMemberInfo tGroupMemberInfo)
    {
        startPage();
        List<TGroupMemberInfo> list = tGroupMemberInfoService.selectTGroupMemberInfoList(tGroupMemberInfo);
        return getDataTable(list);
    }

    /**
     * 导出组内成员信息列表
     */
    @PreAuthorize("@ss.hasPermi('group:member:export')")
    @Log(title = "组内成员信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TGroupMemberInfo tGroupMemberInfo)
    {
        List<TGroupMemberInfo> list = tGroupMemberInfoService.selectTGroupMemberInfoList(tGroupMemberInfo);
        ExcelUtil<TGroupMemberInfo> util = new ExcelUtil<TGroupMemberInfo>(TGroupMemberInfo.class);
        return util.exportExcel(list, "组内成员信息数据");
    }

    /**
     * 获取组内成员信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('group:member:query')")
    @GetMapping(value = "/{memberId}")
    public AjaxResult getInfo(@PathVariable("memberId") Long memberId)
    {
        return AjaxResult.success(tGroupMemberInfoService.selectTGroupMemberInfoById(memberId));
    }

    /**
     * 新增组内成员信息
     */
    @PreAuthorize("@ss.hasPermi('group:member:add')")
    @Log(title = "组内成员信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TGroupMemberInfo tGroupMemberInfo)
    {
        return toAjax(tGroupMemberInfoService.insertTGroupMemberInfo(tGroupMemberInfo));
    }

    /**
     * 修改组内成员信息
     */
    @PreAuthorize("@ss.hasPermi('group:member:edit')")
    @Log(title = "组内成员信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TGroupMemberInfo tGroupMemberInfo)
    {
        return toAjax(tGroupMemberInfoService.updateTGroupMemberInfo(tGroupMemberInfo));
    }

    /**
     * 删除组内成员信息
     */
    @PreAuthorize("@ss.hasPermi('group:member:remove')")
    @Log(title = "组内成员信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{memberIds}")
    public AjaxResult remove(@PathVariable Long[] memberIds)
    {
        return toAjax(tGroupMemberInfoService.deleteTGroupMemberInfoByIds(memberIds));
    }


    /**
     * 获取人员信息
     * @return
     */
    @PostMapping("/selectMemberInfo")
    public AjaxResult selectMemberInfo(@RequestBody Map<String,Object> map){
        return AjaxResult.success(tGroupMemberInfoService.selectMemberInfo(map));
    }
}
