import request from '@/utils/request'

// 查询管线巡检起止列表
export function listUser(query) {
  return request({
    url: '/system/pipetaskuser/list',
    method: 'get',
    params: query
  })
}

// 查询管线巡检起止详细
export function getUser(id) {
  return request({
    url: '/system/pipetaskuser/' + id,
    method: 'get'
  })
}

// 新增管线巡检起止
export function addUser(data) {
  return request({
    url: '/system/pipetaskuser',
    method: 'post',
    data: data
  })
}

// 修改管线巡检起止
export function updateUser(data) {
  return request({
    url: '/system/pipetaskuser',
    method: 'put',
    data: data
  })
}

// 删除管线巡检起止
export function delUser(id) {
  return request({
    url: '/system/pipetaskuser/' + id,
    method: 'delete'
  })
}

// 导出管线巡检起止
export function exportUser(query) {
  return request({
    url: '/system/pipetaskuser/export',
    method: 'get',
    params: query
  })
}
