import request from '@/utils/request'

// 查询隐患日常巡检记录列表
export function listInfo(query) {
  return request({
    url: '/dangerInspect/inspect/list',
    method: 'get',
    params: query
  })
}

// 查询隐患日常巡检记录详细
export function getInfo(id) {
  return request({
    url: '/dangerInspect/inspect/' + id,
    method: 'get'
  })
}

// 新增隐患日常巡检记录
export function addInfo(data) {
  return request({
    url: '/dangerInspect/inspect',
    method: 'post',
    data: data
  })
}

// 修改隐患日常巡检记录
export function updateInfo(data) {
  return request({
    url: '/dangerInspect/inspect',
    method: 'put',
    data: data
  })
}

// 删除隐患日常巡检记录
export function delInfo(id) {
  return request({
    url: '/dangerInspect/inspect/' + id,
    method: 'delete'
  })
}

// 导出隐患日常巡检记录
export function exportInfo(query) {
  return request({
    url: '/dangerInspect/inspect/export',
    method: 'get',
    params: query
  })
}
