package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 工商业用户对象 t_business
 * 
 * @author zehong
 * @date 2023-11-03
 */
public class TBusiness extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long id;

    /** 用户编号（表号） */
    @Excel(name = "用户编号")
    private String usernum;

    /** 合同号 */
    @Excel(name = "合同号")
    private String contract;

    /** 市 */
    private Long city;

    /** 所属区（县） */
    private Long county;

    /** 所属街道（乡镇） */
    private Long street;

    /** 所属小区（村 */
    private Long village;

    @Excel(name = "所属市")
    private String cityName;

    /** 所属区（县） */
    @Excel(name = "所属区")
    private String countyName;

    /** 所属街道（乡镇） */
    @Excel(name = "所属街道")
    private String streetName;

    /** 具体地址 */
    @Excel(name = "具体地址")
    private String address;

    /** 经度 */
    private BigDecimal longitude;

    /** 纬度 */
    private BigDecimal latitude;

    /** 单位名称 */
    @Excel(name = "单位名称")
    private String company;

    /** 用户姓名 */
    @Excel(name = "用户姓名")
    private String username;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String phone;

    /** 表计类型(字典) */
    @Excel(name = "表计类型",dictType="t_meter_type")
    private String type;

    /** 开通状态（字典表 */
    @Excel(name = "开通状态", dictType = "t_user_status")
    private String status;

    /** 通气日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "通气日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date starttime;

    /** 用气设施（字典表） */
    private String device;

    /** 表具类型1皮膜2超声 */
    @Excel(name = "表具类型",readConverterExp="1=皮膜,2=超声")
    private Integer meterType;

    /** 表具厂家1金卡2秦川 */
    @Excel(name = "表具厂家",readConverterExp="1=金卡,2=秦川")
    private Integer meterCompany;

    /** 表具型号1 G1.5、2 G2.5、3 G4 */
    @Excel(name = "表具型号",readConverterExp="1=G1.5,2=G2.5,3=G4")
    private Integer meterModel;

    /** 进气方向1左2右 */
    @Excel(name = "进气方向",readConverterExp="1=左,2=右")
    private Long direction;

    /** 最新任务编号 */
    private Long taskId;

    private Integer ajstatus;

    private String soutext;

    private Integer selectFrom;

    public Integer getSelectFrom() {
        return selectFrom;
    }

    public void setSelectFrom(Integer selectFrom) {
        this.selectFrom = selectFrom;
    }

    public String getSoutext() {
        return soutext;
    }

    public void setSoutext(String soutext) {
        this.soutext = soutext;
    }

    public Integer getAjstatus() {
        return ajstatus;
    }

    public void setAjstatus(Integer ajstatus) {
        this.ajstatus = ajstatus;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setUsernum(String usernum) 
    {
        this.usernum = usernum;
    }

    public String getUsernum() 
    {
        return usernum;
    }
    public void setContract(String contract) 
    {
        this.contract = contract;
    }

    public String getContract() 
    {
        return contract;
    }
    public void setCounty(Long county) 
    {
        this.county = county;
    }

    public Long getCity() {
        return city;
    }

    public void setCity(Long city) {
        this.city = city;
    }

    public Long getCounty()
    {
        return county;
    }
    public void setStreet(Long street) 
    {
        this.street = street;
    }

    public Long getStreet() 
    {
        return street;
    }
    public void setVillage(Long village) 
    {
        this.village = village;
    }

    public Long getVillage() 
    {
        return village;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setCompany(String company) 
    {
        this.company = company;
    }

    public String getCompany() 
    {
        return company;
    }
    public void setUsername(String username) 
    {
        this.username = username;
    }

    public String getUsername() 
    {
        return username;
    }
    public void setPhone(String phone) 
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }
    public void setType(String type) 
    {
        this.type = type;
    }

    public String getType() 
    {
        return type;
    }
    public void setStatus(String status) 
    {
        this.status = status;
    }

    public String getStatus() 
    {
        return status;
    }
    public void setStarttime(Date starttime) 
    {
        this.starttime = starttime;
    }

    public Date getStarttime() 
    {
        return starttime;
    }
    public void setDevice(String device) 
    {
        this.device = device;
    }

    public String getDevice() 
    {
        return device;
    }
    public void setMeterType(Integer meterType) 
    {
        this.meterType = meterType;
    }

    public Integer getMeterType() 
    {
        return meterType;
    }
    public void setMeterCompany(Integer meterCompany) 
    {
        this.meterCompany = meterCompany;
    }

    public Integer getMeterCompany() 
    {
        return meterCompany;
    }
    public void setMeterModel(Integer meterModel) 
    {
        this.meterModel = meterModel;
    }

    public Integer getMeterModel() 
    {
        return meterModel;
    }
    public void setDirection(Long direction) 
    {
        this.direction = direction;
    }

    public Long getDirection() 
    {
        return direction;
    }
    public void setTaskId(Long taskId) 
    {
        this.taskId = taskId;
    }

    public Long getTaskId() 
    {
        return taskId;
    }

    public String getCityName() {
        return cityName;
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    public String getCountyName() {
        return countyName;
    }

    public void setCountyName(String countyName) {
        this.countyName = countyName;
    }

    public String getStreetName() {
        return streetName;
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
    }


    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("usernum", getUsernum())
            .append("contract", getContract())
            .append("county", getCounty())
            .append("street", getStreet())
            .append("village", getVillage())
            .append("address", getAddress())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("company", getCompany())
            .append("username", getUsername())
            .append("phone", getPhone())
            .append("type", getType())
            .append("status", getStatus())
            .append("starttime", getStarttime())
            .append("device", getDevice())
            .append("meterType", getMeterType())
            .append("meterCompany", getMeterCompany())
            .append("meterModel", getMeterModel())
            .append("direction", getDirection())
            .append("taskId", getTaskId())
            .append("remark", getRemark())
            .toString();
    }
}
