package com.zehong.web.controller.baseinfo;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TArea;
import com.zehong.system.service.ITAreaService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 地区县镇Controller
 * 
 * @author zehong
 * @date 2023-11-03
 */
@RestController
@RequestMapping("/system/area")
public class TAreaController extends BaseController
{
    @Autowired
    private ITAreaService tAreaService;

    /**
     * 查询地区县镇列表
     */
    //@PreAuthorize("@ss.hasPermi('system:area:list')")
    @GetMapping("/list")
    public TableDataInfo list(TArea tArea)
    {
        startPage();
        List<TArea> list = tAreaService.selectTAreaList(tArea);
        return getDataTable(list);
    }

    /**
     * 地区列表
     * @return
     */
    @GetMapping("/aLLAreaListInfo")
    public AjaxResult aLLAreaListInfo(TArea tArea){
        return AjaxResult.success(tAreaService.selectTAreaList(tArea));
    }

    /**
     * 导出地区县镇列表
     */
    //@PreAuthorize("@ss.hasPermi('system:area:export')")
    @Log(title = "地区县镇", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TArea tArea)
    {
        List<TArea> list = tAreaService.selectTAreaList(tArea);
        ExcelUtil<TArea> util = new ExcelUtil<TArea>(TArea.class);
        return util.exportExcel(list, "地区县镇数据");
    }

    /**
     * 获取地区县镇详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:area:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tAreaService.selectTAreaById(id));
    }

    /**
     * 新增地区县镇
     */
    //@PreAuthorize("@ss.hasPermi('system:area:add')")
    @Log(title = "地区县镇", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TArea tArea)
    {
        return toAjax(tAreaService.insertTArea(tArea));
    }

    /**
     * 修改地区县镇
     */
    //@PreAuthorize("@ss.hasPermi('system:area:edit')")
    @Log(title = "地区县镇", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TArea tArea)
    {
        return toAjax(tAreaService.updateTArea(tArea));
    }

    /**
     * 删除地区县镇
     */
    //@PreAuthorize("@ss.hasPermi('system:area:remove')")
    @Log(title = "地区县镇", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tAreaService.deleteTAreaByIds(ids));
    }
}
