package com.zehong.system.service.impl;

import java.util.List;

import com.zehong.common.exception.CustomException;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TEmergencyAlarmRelationInfo;
import com.zehong.system.domain.TUrgentContactsGroupInfo;
import com.zehong.system.mapper.TEmergencyAlarmRelationInfoMapper;
import com.zehong.system.mapper.TUrgentContactsGroupInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEmergencyAlarmInfoMapper;
import com.zehong.system.domain.TEmergencyAlarmInfo;
import com.zehong.system.service.ITEmergencyAlarmInfoService;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;

/**
 * 应急报警Service业务层处理
 * 
 * @author zehong
 * @date 2024-12-09
 */
@Service
public class TEmergencyAlarmInfoServiceImpl implements ITEmergencyAlarmInfoService 
{
    @Autowired
    private TEmergencyAlarmInfoMapper tEmergencyAlarmInfoMapper;

    @Resource
    private TEmergencyAlarmRelationInfoMapper tEmergencyAlarmRelationInfoMapper;

    @Resource
    private TUrgentContactsGroupInfoMapper tUrgentContactsGroupInfoMapper;

    /**
     * 查询应急报警
     * 
     * @param id 应急报警ID
     * @return 应急报警
     */
    @Override
    public TEmergencyAlarmInfo selectTEmergencyAlarmInfoById(Long id)
    {
        return tEmergencyAlarmInfoMapper.selectTEmergencyAlarmInfoById(id);
    }

    /**
     * 查询应急报警列表
     * 
     * @param tEmergencyAlarmInfo 应急报警
     * @return 应急报警
     */
    @Override
    public List<TEmergencyAlarmInfo> selectTEmergencyAlarmInfoList(TEmergencyAlarmInfo tEmergencyAlarmInfo)
    {
        return tEmergencyAlarmInfoMapper.selectTEmergencyAlarmInfoList(tEmergencyAlarmInfo);
    }

    /**
     * 新增应急报警
     * 
     * @param tEmergencyAlarmInfo 应急报警
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insertTEmergencyAlarmInfo(TEmergencyAlarmInfo tEmergencyAlarmInfo)
    {
        tEmergencyAlarmInfo.setCreateTime(DateUtils.getNowDate());
        tEmergencyAlarmInfo.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserId().toString());
        int result = tEmergencyAlarmInfoMapper.insertTEmergencyAlarmInfo(tEmergencyAlarmInfo);
        if(0 == result) throw new CustomException("应急报警新增失败");

        //2025-01-02 改选择联系人为选择组号
        /*if (!CollectionUtils.isEmpty(tEmergencyAlarmInfo.getDisposerId())){
            insertTEmergencyAlarmInfoRelation(tEmergencyAlarmInfo.getDisposerId(),tEmergencyAlarmInfo.getId(),"2");
        }*/

        //校验分组是否设置应急联系人
        TUrgentContactsGroupInfo groupInfo = new TUrgentContactsGroupInfo();
        groupInfo.setGroupId(tEmergencyAlarmInfo.getGroupId());
        List<TUrgentContactsGroupInfo> groupInfoList = tUrgentContactsGroupInfoMapper.selectTUrgentContactsGroupInfoList(groupInfo);
        if(CollectionUtils.isEmpty(groupInfoList)) throw new CustomException("该组号未设置应急联系人");
        if (!CollectionUtils.isEmpty(tEmergencyAlarmInfo.getPlanId())){
            insertTEmergencyAlarmInfoRelation(tEmergencyAlarmInfo.getPlanId(),tEmergencyAlarmInfo.getId(),"1");
        }

        return result;
    }

    /**
     * 新增应急报警关联
     * @param ids 关联主键
     * @param alarmId 应急报警主键
     * @param relationType 关联类型
     */
    private void insertTEmergencyAlarmInfoRelation(List<Long> ids,Long alarmId,String relationType){
        for(Long id : ids){
            TEmergencyAlarmRelationInfo relationInfo = new TEmergencyAlarmRelationInfo();
            relationInfo.setAlarmId(alarmId);
            relationInfo.setRelationId(id);
            relationInfo.setRelationType(relationType);
            relationInfo.setCreateTime(DateUtils.getNowDate());
            relationInfo.setCreateBy(SecurityUtils.getLoginUser().getUser().getUserId().toString());
            int result = tEmergencyAlarmRelationInfoMapper.insertTEmergencyAlarmRelationInfo(relationInfo);
            if(0 == result) throw new CustomException("应急报警新增失败");
        }
    }

    /**
     * 修改应急报警
     * 
     * @param tEmergencyAlarmInfo 应急报警
     * @return 结果
     */
    @Override
    public int updateTEmergencyAlarmInfo(TEmergencyAlarmInfo tEmergencyAlarmInfo)
    {
        return tEmergencyAlarmInfoMapper.updateTEmergencyAlarmInfo(tEmergencyAlarmInfo);
    }

    /**
     * 批量删除应急报警
     * 
     * @param ids 需要删除的应急报警ID
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int deleteTEmergencyAlarmInfoByIds(Long[] ids)
    {
        for(Long id : ids){
            tEmergencyAlarmRelationInfoMapper.deleteTEmergencyAlarmRelationInfoByAlarmId(id);
        }
        return tEmergencyAlarmInfoMapper.deleteTEmergencyAlarmInfoByIds(ids);
    }

    /**
     * 删除应急报警信息
     * 
     * @param id 应急报警ID
     * @return 结果
     */
    @Override
    public int deleteTEmergencyAlarmInfoById(Long id)
    {
        return tEmergencyAlarmInfoMapper.deleteTEmergencyAlarmInfoById(id);
    }
}
