package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TSpecialDocumentSign;
import org.apache.ibatis.annotations.Param;

/**
 * 特殊作业单签字Mapper接口
 * 
 * @author zehong
 * @date 2023-12-04
 */
public interface TSpecialDocumentSignMapper 
{
    /**
     * 查询特殊作业单签字
     * 
     * @param id 特殊作业单签字ID
     * @return 特殊作业单签字
     */
    public TSpecialDocumentSign selectTSpecialDocumentSignById(Long id);

    /**
     * 查询特殊作业单签字列表
     * 
     * @param tSpecialDocumentSign 特殊作业单签字
     * @return 特殊作业单签字集合
     */
    public List<TSpecialDocumentSign> selectTSpecialDocumentSignList(TSpecialDocumentSign tSpecialDocumentSign);

    /**
     * 新增特殊作业单签字
     * 
     * @param tSpecialDocumentSign 特殊作业单签字
     * @return 结果
     */
    public int insertTSpecialDocumentSign(TSpecialDocumentSign tSpecialDocumentSign);

    /**
     * 修改特殊作业单签字
     * 
     * @param tSpecialDocumentSign 特殊作业单签字
     * @return 结果
     */
    public int updateTSpecialDocumentSign(TSpecialDocumentSign tSpecialDocumentSign);

    /**
     * 查询下一个签字人
     * @param specialId
     * @param sort
     * @return
     */
    public TSpecialDocumentSign selectNext(@Param("specialId") Long specialId, @Param("sort") Integer sort);

    /**
     * 查询不需要排序签字的人
     * @param specialId
     * @param sort
     * @return
     */
    public TSpecialDocumentSign selectNotsrot(@Param("specialId") Long specialId, @Param("sort") Integer sort);

    /**
     * 删除特殊作业单签字
     * 
     * @param id 特殊作业单签字ID
     * @return 结果
     */
    public int deleteTSpecialDocumentSignById(Long id);

    /**
     * 批量删除特殊作业单签字
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    public int deleteTSpecialDocumentSignByIds(Long[] ids);

    public int deleteBySpecialId(Long sid);
}
