package com.zehong.system.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 【请填写功能名称】对象 t_dev_life_cycle
 * 
 * @author zehong
 * @date 2023-12-12
 */
public class TDevLifeCycle extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long id;

    /** 设备类型 */
    @Excel(name = "设备类型")
    private String devType;

    public String getJianxiu() {
        return jianxiu;
    }

    public void setJianxiu(String jianxiu) {
        this.jianxiu = jianxiu;
    }

    private String jianxiu;

    public String getDevTypeName() {
        return devTypeName;
    }

    public void setDevTypeName(String devTypeName) {
        this.devTypeName = devTypeName;
    }

    private String devTypeName;

    /** 设备名称 */
    @Excel(name = "设备名称")
    private String devName;

    /** 设备编号 */
    @Excel(name = "设备编号")
    private String devNo;

    /** 设备位置 */
    @Excel(name = "设备位置")
    private String devAddr;

    /** 设备描述 */
    @Excel(name = "设备描述")
    private String devDescribe;

    /** 制造单位 */
    @Excel(name = "制造单位")
    private String devCompany;

    /** 设备状态1正常2停用9报废 */
    @Excel(name = "设备状态1正常2停用9报废")
    private String devStatus;

    /** 预警天数 */
    @Excel(name = "预警天数")
    private Long alarmDays;

    /** 启用日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "启用日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date useDate;

    /** 最新检修日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "最新检修日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date currOverhaulDate;

    /** 下次检修日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "下次检修日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date nextOverhaulDate;

    /** 最新保养日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "最新保养日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date currMaintenanceDate;

    /** 下次保养日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "下次保养日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date nextMaintenanceDate;

    private String soutext;

    public String getSoutext() {
        return soutext;
    }

    public void setSoutext(String soutext) {
        this.soutext = soutext;
    }

    public void setId(Long id)
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setDevType(String devType) 
    {
        this.devType = devType;
    }

    public String getDevType() 
    {
        return devType;
    }
    public void setDevName(String devName) 
    {
        this.devName = devName;
    }

    public String getDevName() 
    {
        return devName;
    }
    public void setDevNo(String devNo) 
    {
        this.devNo = devNo;
    }

    public String getDevNo() 
    {
        return devNo;
    }
    public void setDevAddr(String devAddr) 
    {
        this.devAddr = devAddr;
    }

    public String getDevAddr() 
    {
        return devAddr;
    }
    public void setDevDescribe(String devDescribe) 
    {
        this.devDescribe = devDescribe;
    }

    public String getDevDescribe() 
    {
        return devDescribe;
    }

    public String getDevCompany() {
        return devCompany;
    }

    public void setDevCompany(String devCompany) {
        this.devCompany = devCompany;
    }

    public void setDevStatus(String devStatus)
    {
        this.devStatus = devStatus;
    }

    public String getDevStatus()
    {
        return devStatus;
    }
    public void setAlarmDays(Long alarmDays) 
    {
        this.alarmDays = alarmDays;
    }

    public Long getAlarmDays() 
    {
        return alarmDays;
    }
    public void setUseDate(Date useDate) 
    {
        this.useDate = useDate;
    }

    public Date getUseDate() 
    {
        return useDate;
    }
    public void setCurrOverhaulDate(Date currOverhaulDate) 
    {
        this.currOverhaulDate = currOverhaulDate;
    }

    public Date getCurrOverhaulDate() 
    {
        return currOverhaulDate;
    }
    public void setNextOverhaulDate(Date nextOverhaulDate) 
    {
        this.nextOverhaulDate = nextOverhaulDate;
    }

    public Date getNextOverhaulDate() 
    {
        return nextOverhaulDate;
    }
    public void setCurrMaintenanceDate(Date currMaintenanceDate) 
    {
        this.currMaintenanceDate = currMaintenanceDate;
    }

    public Date getCurrMaintenanceDate() 
    {
        return currMaintenanceDate;
    }
    public void setNextMaintenanceDate(Date nextMaintenanceDate) 
    {
        this.nextMaintenanceDate = nextMaintenanceDate;
    }

    public Date getNextMaintenanceDate() 
    {
        return nextMaintenanceDate;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("devType", getDevType())
            .append("devName", getDevName())
            .append("devNo", getDevNo())
            .append("devAddr", getDevAddr())
            .append("devDescribe", getDevDescribe())
            .append("devStatus", getDevStatus())
            .append("alarmDays", getAlarmDays())
            .append("useDate", getUseDate())
            .append("currOverhaulDate", getCurrOverhaulDate())
            .append("nextOverhaulDate", getNextOverhaulDate())
            .append("currMaintenanceDate", getCurrMaintenanceDate())
            .append("nextMaintenanceDate", getNextMaintenanceDate())
            .append("createTime", getCreateTime())
            .toString();
    }
}
