package com.zehong.web.controller.system;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TMemoryLog;
import com.zehong.system.service.ITMemoryLogService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 内存报警日志Controller
 * 
 * @author zehong
 * @date 2024-05-08
 */
@RestController
@RequestMapping("/system/log")
public class TMemoryLogController extends BaseController
{
    @Autowired
    private ITMemoryLogService tMemoryLogService;

    /**
     * 查询内存报警日志列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TMemoryLog tMemoryLog)
    {
        startPage();
        List<TMemoryLog> list = tMemoryLogService.selectTMemoryLogList(tMemoryLog);
        return getDataTable(list);
    }

    /**
     * 导出内存报警日志列表
     */
    @Log(title = "内存报警日志", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TMemoryLog tMemoryLog)
    {
        List<TMemoryLog> list = tMemoryLogService.selectTMemoryLogList(tMemoryLog);
        ExcelUtil<TMemoryLog> util = new ExcelUtil<TMemoryLog>(TMemoryLog.class);
        return util.exportExcel(list, "内存报警日志数据");
    }

    /**
     * 获取内存报警日志详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tMemoryLogService.selectTMemoryLogById(id));
    }

    /**
     * 新增内存报警日志
     */
    @Log(title = "内存报警日志", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TMemoryLog tMemoryLog)
    {
        return toAjax(tMemoryLogService.insertTMemoryLog(tMemoryLog));
    }

    /**
     * 修改内存报警日志
     */
    @Log(title = "内存报警日志", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TMemoryLog tMemoryLog)
    {
        return toAjax(tMemoryLogService.updateTMemoryLog(tMemoryLog));
    }

    /**
     * 删除内存报警日志
     */
    @Log(title = "内存报警日志", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tMemoryLogService.deleteTMemoryLogByIds(ids));
    }
}
