package com.zehong.web.controller.system;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TClockIn;
import com.zehong.system.service.ITClockInService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 考勤打卡Controller
 * 
 * @author zehong
 * @date 2023-11-15
 */
@RestController
@RequestMapping("/system/in")
public class TClockInController extends BaseController
{
    @Autowired
    private ITClockInService tClockInService;

    /**
     * 查询考勤打卡列表
     */
    @GetMapping("/list")
    public TableDataInfo list(TClockIn tClockIn)
    {
        startPage();
        List<TClockIn> list = tClockInService.selectTClockInList(tClockIn);
        return getDataTable(list);
    }

    /**
     * 导出考勤打卡列表
     */
    @Log(title = "考勤打卡", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TClockIn tClockIn)
    {
        List<TClockIn> list = tClockInService.selectTClockInList(tClockIn);
        ExcelUtil<TClockIn> util = new ExcelUtil<TClockIn>(TClockIn.class);
        return util.exportExcel(list, "考勤打卡数据");
    }

    /**
     * 获取考勤打卡详细信息
     */
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tClockInService.selectTClockInById(id));
    }

    /**
     * 新增考勤打卡
     */
    @Log(title = "考勤打卡", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TClockIn tClockIn)
    {
        return toAjax(tClockInService.insertTClockIn(tClockIn));
    }

    /**
     * 修改考勤打卡
     */
    @Log(title = "考勤打卡", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TClockIn tClockIn)
    {
        return toAjax(tClockInService.updateTClockIn(tClockIn));
    }

    /**
     * 删除考勤打卡
     */
    @Log(title = "考勤打卡", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tClockInService.deleteTClockInByIds(ids));
    }
}
