package com.zehong.web.controller.group;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TPersonGroupInfo;
import com.zehong.system.service.ITPersonGroupInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 人员分组信息Controller
 * 
 * @author zehong
 * @date 2025-12-05
 */
@RestController
@RequestMapping("/group/info")
public class TPersonGroupInfoController extends BaseController
{
    @Autowired
    private ITPersonGroupInfoService tPersonGroupInfoService;

    /**
     * 查询人员分组信息列表
     */
    @PreAuthorize("@ss.hasPermi('group:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(TPersonGroupInfo tPersonGroupInfo)
    {
        startPage();
        List<TPersonGroupInfo> list = tPersonGroupInfoService.selectTPersonGroupInfoList(tPersonGroupInfo);
        return getDataTable(list);
    }

    @GetMapping("/personGroupInfoList")
    public AjaxResult personGroupInfoList(TPersonGroupInfo tPersonGroupInfo) {
        List<TPersonGroupInfo> list = tPersonGroupInfoService.selectTPersonGroupInfoList(tPersonGroupInfo);
        return AjaxResult.success(list);
    }

    /**
     * 导出人员分组信息列表
     */
    @PreAuthorize("@ss.hasPermi('group:info:export')")
    @Log(title = "人员分组信息", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TPersonGroupInfo tPersonGroupInfo)
    {
        List<TPersonGroupInfo> list = tPersonGroupInfoService.selectTPersonGroupInfoList(tPersonGroupInfo);
        ExcelUtil<TPersonGroupInfo> util = new ExcelUtil<TPersonGroupInfo>(TPersonGroupInfo.class);
        return util.exportExcel(list, "人员分组信息数据");
    }

    /**
     * 获取人员分组信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('group:info:query')")
    @GetMapping(value = "/{groupId}")
    public AjaxResult getInfo(@PathVariable("groupId") Long groupId)
    {
        return AjaxResult.success(tPersonGroupInfoService.selectTPersonGroupInfoById(groupId));
    }

    /**
     * 新增人员分组信息
     */
    @PreAuthorize("@ss.hasPermi('group:info:add')")
    @Log(title = "人员分组信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TPersonGroupInfo tPersonGroupInfo)
    {
        return toAjax(tPersonGroupInfoService.insertTPersonGroupInfo(tPersonGroupInfo));
    }

    /**
     * 修改人员分组信息
     */
    @PreAuthorize("@ss.hasPermi('group:info:edit')")
    @Log(title = "人员分组信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TPersonGroupInfo tPersonGroupInfo)
    {
        return toAjax(tPersonGroupInfoService.updateTPersonGroupInfo(tPersonGroupInfo));
    }

    /**
     * 删除人员分组信息
     */
    @PreAuthorize("@ss.hasPermi('group:info:remove')")
    @Log(title = "人员分组信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{groupIds}")
    public AjaxResult remove(@PathVariable Long[] groupIds)
    {
        return toAjax(tPersonGroupInfoService.deleteTPersonGroupInfoByIds(groupIds));
    }
}
