package com.zehong.web.controller.emergency;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zehong.common.annotation.Log;
import com.zehong.common.core.controller.BaseController;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.common.enums.BusinessType;
import com.zehong.system.domain.TEmergencyAlarmInfo;
import com.zehong.system.service.ITEmergencyAlarmInfoService;
import com.zehong.common.utils.poi.ExcelUtil;
import com.zehong.common.core.page.TableDataInfo;

/**
 * 应急报警Controller
 * 
 * @author zehong
 * @date 2024-12-09
 */
@RestController
@RequestMapping("/emergency/alarm")
public class TEmergencyAlarmInfoController extends BaseController
{
    @Autowired
    private ITEmergencyAlarmInfoService tEmergencyAlarmInfoService;

    /**
     * 查询应急报警列表
     */
    //@PreAuthorize("@ss.hasPermi('system:info:list')")
    @GetMapping("/list")
    public TableDataInfo list(TEmergencyAlarmInfo tEmergencyAlarmInfo)
    {
        startPage();
        List<TEmergencyAlarmInfo> list = tEmergencyAlarmInfoService.selectTEmergencyAlarmInfoList(tEmergencyAlarmInfo);
        return getDataTable(list);
    }

    /**
     * 导出应急报警列表
     */
    //@PreAuthorize("@ss.hasPermi('system:info:export')")
    @Log(title = "应急报警", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TEmergencyAlarmInfo tEmergencyAlarmInfo)
    {
        List<TEmergencyAlarmInfo> list = tEmergencyAlarmInfoService.selectTEmergencyAlarmInfoList(tEmergencyAlarmInfo);
        ExcelUtil<TEmergencyAlarmInfo> util = new ExcelUtil<TEmergencyAlarmInfo>(TEmergencyAlarmInfo.class);
        return util.exportExcel(list, "应急报警数据");
    }

    /**
     * 获取应急报警详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:info:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return AjaxResult.success(tEmergencyAlarmInfoService.selectTEmergencyAlarmInfoById(id));
    }

    /**
     * 新增应急报警
     */
    //@PreAuthorize("@ss.hasPermi('system:info:add')")
    @Log(title = "应急报警", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TEmergencyAlarmInfo tEmergencyAlarmInfo)
    {
        return toAjax(tEmergencyAlarmInfoService.insertTEmergencyAlarmInfo(tEmergencyAlarmInfo));
    }

    /**
     * 修改应急报警
     */
    //@PreAuthorize("@ss.hasPermi('system:info:edit')")
    @Log(title = "应急报警", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TEmergencyAlarmInfo tEmergencyAlarmInfo)
    {
        return toAjax(tEmergencyAlarmInfoService.updateTEmergencyAlarmInfo(tEmergencyAlarmInfo));
    }

    /**
     * 删除应急报警
     */
   // @PreAuthorize("@ss.hasPermi('system:info:remove')")
    @Log(title = "应急报警", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tEmergencyAlarmInfoService.deleteTEmergencyAlarmInfoByIds(ids));
    }
}
