import request from '@/utils/request'

// 查询应急联系人分组列表
export function listInfo(query) {
  return request({
    url: '/urgent/group/list',
    method: 'get',
    params: query
  })
}

export function contactsInfoList(query) {
  return request({
    url: '/urgent/group/contactsInfoList',
    method: 'get',
    params: query
  })
}

// 查询应急联系人分组详细
export function getInfo(id) {
  return request({
    url: '/urgent/group/' + id,
    method: 'get'
  })
}

// 新增应急联系人分组
export function addInfo(data) {
  return request({
    url: '/urgent/group',
    method: 'post',
    data: data
  })
}

// 修改应急联系人分组
export function updateInfo(data) {
  return request({
    url: '/urgent/group',
    method: 'put',
    data: data
  })
}

// 删除应急联系人分组
export function delInfo(id) {
  return request({
    url: '/urgent/group/' + id,
    method: 'delete'
  })
}

// 导出应急联系人分组
export function exportInfo(query) {
  return request({
    url: '/urgent/group/export',
    method: 'get',
    params: query
  })
}

//根据组号删除
export function deleteTUrgentContactsGroupInfoByGroupId(query) {
  return request({
    url: '/urgent/group/deleteTUrgentContactsGroupInfoByGroupId',
    method: 'get',
    params: query
  })
}
