package com.zehong.system.service.impl;

import java.util.Date;
import java.util.List;

import com.zehong.system.domain.TSpecialDocument;
import com.zehong.system.mapper.TSpecialDocumentMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TSpecialDocumentSignMapper;
import com.zehong.system.domain.TSpecialDocumentSign;
import com.zehong.system.service.ITSpecialDocumentSignService;
import org.springframework.transaction.annotation.Transactional;

/**
 * 特殊作业单签字Service业务层处理
 * 
 * @author zehong
 * @date 2023-12-04
 */
@Service
public class TSpecialDocumentSignServiceImpl implements ITSpecialDocumentSignService 
{
    @Autowired
    private TSpecialDocumentSignMapper tSpecialDocumentSignMapper;
    @Autowired
    private TSpecialDocumentMapper tSpecialDocumentMapper;

    /**
     * 查询特殊作业单签字
     * 
     * @param id 特殊作业单签字ID
     * @return 特殊作业单签字
     */
    @Override
    public TSpecialDocumentSign selectTSpecialDocumentSignById(Long id)
    {
        return tSpecialDocumentSignMapper.selectTSpecialDocumentSignById(id);
    }

    /**
     * 查询特殊作业单签字列表
     * 
     * @param tSpecialDocumentSign 特殊作业单签字
     * @return 特殊作业单签字
     */
    @Override
    public List<TSpecialDocumentSign> selectTSpecialDocumentSignList(TSpecialDocumentSign tSpecialDocumentSign)
    {
        return tSpecialDocumentSignMapper.selectTSpecialDocumentSignList(tSpecialDocumentSign);
    }

    /**
     * 新增特殊作业单签字
     * 
     * @param tSpecialDocumentSign 特殊作业单签字
     * @return 结果
     */
    @Override
    public int insertTSpecialDocumentSign(TSpecialDocumentSign tSpecialDocumentSign)
    {
        return tSpecialDocumentSignMapper.insertTSpecialDocumentSign(tSpecialDocumentSign);
    }

    /**
     * 修改特殊作业单签字
     * 
     * @param tSpecialDocumentSign 特殊作业单签字
     * @return 结果
     */
    @Override
    public int updateTSpecialDocumentSign(TSpecialDocumentSign tSpecialDocumentSign)
    {
        return tSpecialDocumentSignMapper.updateTSpecialDocumentSign(tSpecialDocumentSign);
    }

    /**
     *  修改签字状态
     * @param ss
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateSign(TSpecialDocumentSign ss)
    {
        TSpecialDocument td = tSpecialDocumentMapper.selectTSpecialDocumentById(ss.getSpecialId());
        ss.setTurnSign(0);
        ss.setSignTime(new Date());
        int a = tSpecialDocumentSignMapper.updateTSpecialDocumentSign(ss);
        if(ss.getSort()>0){//需要排序的签字
            TSpecialDocumentSign sign = tSpecialDocumentSignMapper.selectNext(ss.getSpecialId(),ss.getSort());
            if(sign!=null){
                sign.setTurnSign(1);
                tSpecialDocumentSignMapper.updateTSpecialDocumentSign(sign);
                if (sign.getSort()==5||(sign.getSort()==4&&td.getDocumentType()==3)||(sign.getSort()==3&&td.getDocumentType()==7)) {
                    //TSpecialDocument td = new TSpecialDocument();
                    //td.setId(ss.getSpecialId());
                    td.setStatus(3);
                    tSpecialDocumentMapper.updateTSpecialDocument(td);
                }
            }else {
//                TSpecialDocument td = new TSpecialDocument();
//                td.setId(ss.getSpecialId());
                td.setStatus(4);
                tSpecialDocumentMapper.updateTSpecialDocument(td);
            }
        }else {//不需要排序的签字
            TSpecialDocumentSign sign = tSpecialDocumentSignMapper.selectNotsrot(ss.getSpecialId(),ss.getSort());
            if(sign==null){
                TSpecialDocumentSign nextsign = tSpecialDocumentSignMapper.selectNext(ss.getSpecialId(),0);
                if(nextsign!=null){
                    nextsign.setTurnSign(1);
                    tSpecialDocumentSignMapper.updateTSpecialDocumentSign(nextsign);
                }
            }
        }
        return a;
    }

    /**
     * 批量删除特殊作业单签字
     * 
     * @param ids 需要删除的特殊作业单签字ID
     * @return 结果
     */
    @Override
    public int deleteTSpecialDocumentSignByIds(Long[] ids)
    {
        return tSpecialDocumentSignMapper.deleteTSpecialDocumentSignByIds(ids);
    }

    /**
     * 删除特殊作业单签字信息
     * 
     * @param id 特殊作业单签字ID
     * @return 结果
     */
    @Override
    public int deleteTSpecialDocumentSignById(Long id)
    {
        return tSpecialDocumentSignMapper.deleteTSpecialDocumentSignById(id);
    }
}
