package com.zehong.system.service.impl;

import java.util.Date;
import java.util.List;
import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.system.domain.TGroupMemberInfo;
import com.zehong.system.mapper.TGroupMemberInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TPersonGroupInfoMapper;
import com.zehong.system.domain.TPersonGroupInfo;
import com.zehong.system.service.ITPersonGroupInfoService;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;

/**
 * 人员分组信息Service业务层处理
 * 
 * @author zehong
 * @date 2025-12-05
 */
@Service
public class TPersonGroupInfoServiceImpl implements ITPersonGroupInfoService 
{
    @Resource
    private TPersonGroupInfoMapper tPersonGroupInfoMapper;

    @Resource
    private TGroupMemberInfoMapper groupMemberInfoMapper;

    /**
     * 查询人员分组信息
     * 
     * @param groupId 人员分组信息ID
     * @return 人员分组信息
     */
    @Override
    public TPersonGroupInfo selectTPersonGroupInfoById(Long groupId) {
        TPersonGroupInfo groupInfo = tPersonGroupInfoMapper.selectTPersonGroupInfoById(groupId);
        TGroupMemberInfo tGroupMemberInfo = new TGroupMemberInfo();
        tGroupMemberInfo.setGroupId(groupId);
        List<TGroupMemberInfo> memberInfoList = groupMemberInfoMapper.selectTGroupMemberInfoList(tGroupMemberInfo);
        groupInfo.setMemberInfoList(memberInfoList);
        return groupInfo;
    }

    /**
     * 查询人员分组信息列表
     * 
     * @param tPersonGroupInfo 人员分组信息
     * @return 人员分组信息
     */
    @Override
    public List<TPersonGroupInfo> selectTPersonGroupInfoList(TPersonGroupInfo tPersonGroupInfo)
    {
        return tPersonGroupInfoMapper.selectTPersonGroupInfoList(tPersonGroupInfo);
    }

    /**
     * 新增人员分组信息
     * 
     * @param tPersonGroupInfo 人员分组信息
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int insertTPersonGroupInfo(TPersonGroupInfo tPersonGroupInfo) {
        tPersonGroupInfo.setCreateTime(DateUtils.getNowDate());
        tPersonGroupInfo.setCreateBy(SecurityUtils.getLoginUser().getUser().getNickName());
        int result = tPersonGroupInfoMapper.insertTPersonGroupInfo(tPersonGroupInfo);
        addMemberInfo(tPersonGroupInfo);
        return result;
    }

    /**
     * 新增组成员
     * @param tPersonGroupInfo 组信息
     */
    private void addMemberInfo(TPersonGroupInfo tPersonGroupInfo){
        for(TGroupMemberInfo memberInfo : tPersonGroupInfo.getMemberInfoList()){
            memberInfo.setGroupId(tPersonGroupInfo.getGroupId());
            memberInfo.setCreateTime(new Date());
            memberInfo.setCreateBy(SecurityUtils.getLoginUser().getUser().getNickName());
            groupMemberInfoMapper.insertTGroupMemberInfo(memberInfo);
        }
    }

    /**
     * 修改人员分组信息
     * 
     * @param tPersonGroupInfo 人员分组信息
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int updateTPersonGroupInfo(TPersonGroupInfo tPersonGroupInfo) {
        tPersonGroupInfo.setUpdateTime(DateUtils.getNowDate());
        tPersonGroupInfo.setUpdateBy(SecurityUtils.getLoginUser().getUser().getNickName());
        groupMemberInfoMapper.deleteTGroupMemberInfoByGroupId(tPersonGroupInfo.getGroupId());
        addMemberInfo(tPersonGroupInfo);
        return tPersonGroupInfoMapper.updateTPersonGroupInfo(tPersonGroupInfo);
    }

    /**
     * 批量删除人员分组信息
     * 
     * @param groupIds 需要删除的人员分组信息ID
     * @return 结果
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int deleteTPersonGroupInfoByIds(Long[] groupIds) {
        for(Long groupId : groupIds){
            groupMemberInfoMapper.deleteTGroupMemberInfoByGroupId(groupId);
        }
        return tPersonGroupInfoMapper.deleteTPersonGroupInfoByIds(groupIds);
    }

    /**
     * 删除人员分组信息信息
     * 
     * @param groupId 人员分组信息ID
     * @return 结果
     */
    @Override
    public int deleteTPersonGroupInfoById(Long groupId)
    {
        return tPersonGroupInfoMapper.deleteTPersonGroupInfoById(groupId);
    }
}
