package com.zehong.system.service.impl;

import java.util.Date;
import java.util.List;

import com.zehong.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zehong.system.mapper.TEmergencyDisposeStepMapper;
import com.zehong.system.domain.TEmergencyDisposeStep;
import com.zehong.system.service.ITEmergencyDisposeStepService;

/**
 * 应急处置步骤Service业务层处理
 * 
 * @author zehong
 * @date 2024-09-07
 */
@Service
public class TEmergencyDisposeStepServiceImpl implements ITEmergencyDisposeStepService 
{
    @Autowired
    private TEmergencyDisposeStepMapper tEmergencyDisposeStepMapper;

    /**
     * 查询应急处置步骤
     * 
     * @param stepId 应急处置步骤ID
     * @return 应急处置步骤
     */
    @Override
    public TEmergencyDisposeStep selectTEmergencyDisposeStepById(Long stepId)
    {
        return tEmergencyDisposeStepMapper.selectTEmergencyDisposeStepById(stepId);
    }

    /**
     * 查询应急处置步骤列表
     * 
     * @param tEmergencyDisposeStep 应急处置步骤
     * @return 应急处置步骤
     */
    @Override
    public List<TEmergencyDisposeStep> selectTEmergencyDisposeStepList(TEmergencyDisposeStep tEmergencyDisposeStep)
    {
        return tEmergencyDisposeStepMapper.selectTEmergencyDisposeStepList(tEmergencyDisposeStep);
    }

    /**
     * 新增应急处置步骤
     * 
     * @param tEmergencyDisposeStep 应急处置步骤
     * @return 结果
     */
    @Override
    public int insertTEmergencyDisposeStep(TEmergencyDisposeStep tEmergencyDisposeStep)
    {
        tEmergencyDisposeStep.setDisposeTime(new Date());
        tEmergencyDisposeStep.setDisposer(SecurityUtils.getLoginUser().getUser().getUserId());
        return tEmergencyDisposeStepMapper.insertTEmergencyDisposeStep(tEmergencyDisposeStep);
    }

    /**
     * 修改应急处置步骤
     * 
     * @param tEmergencyDisposeStep 应急处置步骤
     * @return 结果
     */
    @Override
    public int updateTEmergencyDisposeStep(TEmergencyDisposeStep tEmergencyDisposeStep)
    {
        return tEmergencyDisposeStepMapper.updateTEmergencyDisposeStep(tEmergencyDisposeStep);
    }

    /**
     * 批量删除应急处置步骤
     * 
     * @param stepIds 需要删除的应急处置步骤ID
     * @return 结果
     */
    @Override
    public int deleteTEmergencyDisposeStepByIds(Long[] stepIds)
    {
        return tEmergencyDisposeStepMapper.deleteTEmergencyDisposeStepByIds(stepIds);
    }

    /**
     * 删除应急处置步骤信息
     * 
     * @param stepId 应急处置步骤ID
     * @return 结果
     */
    @Override
    public int deleteTEmergencyDisposeStepById(Long stepId)
    {
        return tEmergencyDisposeStepMapper.deleteTEmergencyDisposeStepById(stepId);
    }
}
