package com.zehong.system.service.impl;

import com.zehong.common.utils.DateUtils;
import com.zehong.common.utils.SecurityUtils;
import com.zehong.common.utils.bean.BeanUtils;
import com.zehong.system.domain.TDevInspect;
import com.zehong.system.domain.TDevLifeCycle;
import com.zehong.system.mapper.TDevInspectMapper;
import com.zehong.system.mapper.TDevLifeCycleMapper;
import com.zehong.system.service.ITDevLifeCycleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 【请填写功能名称】Service业务层处理
 * 
 * @author zehong
 * @date 2023-12-12
 */
@Service
public class TDevLifeCycleServiceImpl implements ITDevLifeCycleService 
{
    @Autowired
    private TDevLifeCycleMapper tDevLifeCycleMapper;

    @Resource
    private TDevInspectMapper tDevInspectMapper;

    /**
     * 查询【请填写功能名称】
     * 
     * @param id 【请填写功能名称】ID
     * @return 【请填写功能名称】
     */
    @Override
    public TDevLifeCycle selectTDevLifeCycleById(Long id)
    {
        return tDevLifeCycleMapper.selectTDevLifeCycleById(id);
    }

    /**
     * 查询【请填写功能名称】列表
     * 
     * @param tDevLifeCycle 【请填写功能名称】
     * @return 【请填写功能名称】
     */
    @Override
    public List<TDevLifeCycle> selectTDevLifeCycleList(TDevLifeCycle tDevLifeCycle)
    {
        return tDevLifeCycleMapper.selectTDevLifeCycleList(tDevLifeCycle);
    }

    @Override
    public List<TDevLifeCycle> selectTDevLifeCycleListByParam(TDevLifeCycle tDevLifeCycle) {
        return tDevLifeCycleMapper.selectTDevLifeCycleListByParam(tDevLifeCycle);
    }

    /**
     * 临检设备
     * @param tDevLifeCycle 参数
     */
    @Override
    public List<TDevLifeCycle> closeInspectDevice (TDevLifeCycle tDevLifeCycle){
        List<TDevLifeCycle> deviceList = tDevLifeCycleMapper.selectTDevLifeCycleListByParam(tDevLifeCycle);
        return deviceList.stream().filter(item -> "1".equals(item.getJianxiu())).collect(Collectors.toList());
    }

    /**
     * 新增【请填写功能名称】
     * 
     * @param tDevLifeCycle 【请填写功能名称】
     * @return 结果
     */
    @Override
    public int insertTDevLifeCycle(TDevLifeCycle tDevLifeCycle)
    {
        tDevLifeCycle.setCreateTime(DateUtils.getNowDate());
        return tDevLifeCycleMapper.insertTDevLifeCycle(tDevLifeCycle);
    }

    /**
     * 修改【请填写功能名称】
     * 
     * @param tDevLifeCycle 【请填写功能名称】
     * @return 结果
     */
    @Override
    public int updateTDevLifeCycle(TDevLifeCycle tDevLifeCycle)
    {
        return tDevLifeCycleMapper.updateTDevLifeCycle(tDevLifeCycle);
    }

    /**
     * 批量删除【请填写功能名称】
     * 
     * @param ids 需要删除的【请填写功能名称】ID
     * @return 结果
     */
    @Override
    public int deleteTDevLifeCycleByIds(Long[] ids)
    {
        return tDevLifeCycleMapper.deleteTDevLifeCycleByIds(ids);
    }

    /**
     * 删除【请填写功能名称】信息
     * 
     * @param id 【请填写功能名称】ID
     * @return 结果
     */
    @Override
    public int deleteTDevLifeCycleById(Long id)
    {
        return tDevLifeCycleMapper.deleteTDevLifeCycleById(id);
    }


    /**
     * 设备类型统计
     * @return
     */
    @Override
    public List<Map<String,Object>> devLifeStatistic(){
        return tDevLifeCycleMapper.devLifeStatistic();
    }

    /**
     * 批量新增安检单
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public int batchAddInspect(TDevInspect tDevInspect){
        TDevLifeCycle param = new TDevLifeCycle();
        Map<String,Object> batchAddQuery = new HashMap<>();
        batchAddQuery.put("isBatchQuery","1,2");
        param.setParams(batchAddQuery);
        param.setDevType(tDevInspect.getDevType());
        List<TDevLifeCycle> devLifeCycleList = tDevLifeCycleMapper.selectTDevLifeCycleList(param);
        List<TDevInspect> inspectList = new ArrayList<>();
        devLifeCycleList.stream().forEach(item ->{
            TDevInspect inspect = new TDevInspect();
            BeanUtils.copyBeanProp(inspect,tDevInspect);
            inspect.setDevLifeId(item.getId());
            inspect.setAdminId(SecurityUtils.getLoginUser().getUser().getUserId());
            inspect.setCreateTime(new Date());
            item.setCurrOverhaulDate(tDevInspect.getCurrDate());
            item.setNextOverhaulDate(tDevInspect.getNextDate());
            tDevLifeCycleMapper.updateTDevLifeCycle(item);
            inspectList.add(inspect);
        });
        if (CollectionUtils.isEmpty(inspectList)) return 1;
        return tDevInspectMapper.batchAddInspect(inspectList);
    }


}
