package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TEmergencyAlarmInfo;

/**
 * 应急报警Service接口
 * 
 * @author zehong
 * @date 2024-12-09
 */
public interface ITEmergencyAlarmInfoService 
{
    /**
     * 查询应急报警
     * 
     * @param id 应急报警ID
     * @return 应急报警
     */
    public TEmergencyAlarmInfo selectTEmergencyAlarmInfoById(Long id);

    /**
     * 查询应急报警列表
     * 
     * @param tEmergencyAlarmInfo 应急报警
     * @return 应急报警集合
     */
    public List<TEmergencyAlarmInfo> selectTEmergencyAlarmInfoList(TEmergencyAlarmInfo tEmergencyAlarmInfo);

    /**
     * 新增应急报警
     * 
     * @param tEmergencyAlarmInfo 应急报警
     * @return 结果
     */
    public int insertTEmergencyAlarmInfo(TEmergencyAlarmInfo tEmergencyAlarmInfo);

    /**
     * 修改应急报警
     * 
     * @param tEmergencyAlarmInfo 应急报警
     * @return 结果
     */
    public int updateTEmergencyAlarmInfo(TEmergencyAlarmInfo tEmergencyAlarmInfo);

    /**
     * 批量删除应急报警
     * 
     * @param ids 需要删除的应急报警ID
     * @return 结果
     */
    public int deleteTEmergencyAlarmInfoByIds(Long[] ids);

    /**
     * 删除应急报警信息
     * 
     * @param id 应急报警ID
     * @return 结果
     */
    public int deleteTEmergencyAlarmInfoById(Long id);
}
