package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TDevInspect;

/**
 * 设备检验记录（生命全周期）Service接口
 * 
 * @author zehong
 * @date 2023-12-15
 */
public interface ITDevInspectService 
{
    /**
     * 查询设备检验记录（生命全周期）
     * 
     * @param id 设备检验记录（生命全周期）ID
     * @return 设备检验记录（生命全周期）
     */
    public TDevInspect selectTDevInspectById(Long id);

    /**
     * 查询设备检验记录（生命全周期）列表
     * 
     * @param tDevInspect 设备检验记录（生命全周期）
     * @return 设备检验记录（生命全周期）集合
     */
    public List<TDevInspect> selectTDevInspectList(TDevInspect tDevInspect);

    /**
     * 新增设备检验记录（生命全周期）
     * 
     * @param tDevInspect 设备检验记录（生命全周期）
     * @return 结果
     */
    public int insertTDevInspect(TDevInspect tDevInspect);

    /**
     * 修改设备检验记录（生命全周期）
     * 
     * @param tDevInspect 设备检验记录（生命全周期）
     * @return 结果
     */
    public int updateTDevInspect(TDevInspect tDevInspect);

    /**
     * 批量删除设备检验记录（生命全周期）
     * 
     * @param ids 需要删除的设备检验记录（生命全周期）ID
     * @return 结果
     */
    public int deleteTDevInspectByIds(Long[] ids);

    /**
     * 删除设备检验记录（生命全周期）信息
     * 
     * @param id 设备检验记录（生命全周期）ID
     * @return 结果
     */
    public int deleteTDevInspectById(Long id);
}
