package com.zehong.system.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 应急报警通知记录对象 t_emergency_alarm_notify_record
 * 
 * @author zehong
 * @date 2024-12-10
 */
public class TEmergencyAlarmNotifyRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 应急报警主键 */
    @Excel(name = "应急报警主键")
    private Long alarmId;

    /** 处置人 */
    @Excel(name = "处置人")
    private Long disposerId;

    /** 通知结果: 0成功 1失败 */
    @Excel(name = "通知结果: 0成功 1失败")
    private String notifyResult;

    /** 通知类型: 0短信 1语音 */
    @Excel(name = "通知类型: 0短信 1语音")
    private String recordType;

    /** 通知日志 */
    @Excel(name = "通知日志")
    private String notifyLog;

    private String userName;

    private String phone;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }
    public void setAlarmId(Long alarmId) 
    {
        this.alarmId = alarmId;
    }

    public Long getAlarmId() 
    {
        return alarmId;
    }
    public void setDisposerId(Long disposerId) 
    {
        this.disposerId = disposerId;
    }

    public Long getDisposerId() 
    {
        return disposerId;
    }
    public void setNotifyResult(String notifyResult) 
    {
        this.notifyResult = notifyResult;
    }

    public String getNotifyResult() 
    {
        return notifyResult;
    }

    public String getRecordType() {
        return recordType;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    public void setNotifyLog(String notifyLog)
    {
        this.notifyLog = notifyLog;
    }

    public String getNotifyLog() 
    {
        return notifyLog;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("alarmId", getAlarmId())
            .append("disposerId", getDisposerId())
            .append("notifyResult", getNotifyResult())
            .append("notifyLog", getNotifyLog())
            .append("createTime", getCreateTime())
            .append("createBy", getCreateBy())
            .toString();
    }
}
