package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TUrgentContactsGroupInfo;

/**
 * 应急联系人分组Service接口
 * 
 * @author zehong
 * @date 2024-12-31
 */
public interface ITUrgentContactsGroupInfoService 
{
    /**
     * 查询应急联系人分组
     * 
     * @param id 应急联系人分组ID
     * @return 应急联系人分组
     */
    public TUrgentContactsGroupInfo selectTUrgentContactsGroupInfoById(Long id);

    /**
     * 查询应急联系人分组列表
     * 
     * @param tUrgentContactsGroupInfo 应急联系人分组
     * @return 应急联系人分组集合
     */
    public List<TUrgentContactsGroupInfo> selectTUrgentContactsGroupInfoList(TUrgentContactsGroupInfo tUrgentContactsGroupInfo);

    /**
     * 新增应急联系人分组
     * 
     * @param tUrgentContactsGroupInfo 应急联系人分组
     * @return 结果
     */
    public int insertTUrgentContactsGroupInfo(TUrgentContactsGroupInfo tUrgentContactsGroupInfo);

    /**
     * 修改应急联系人分组
     * 
     * @param tUrgentContactsGroupInfo 应急联系人分组
     * @return 结果
     */
    public int updateTUrgentContactsGroupInfo(TUrgentContactsGroupInfo tUrgentContactsGroupInfo);

    /**
     * 批量删除应急联系人分组
     * 
     * @param ids 需要删除的应急联系人分组ID
     * @return 结果
     */
    public int deleteTUrgentContactsGroupInfoByIds(Long[] ids);

    /**
     * 删除应急联系人分组信息
     * 
     * @param id 应急联系人分组ID
     * @return 结果
     */
    public int deleteTUrgentContactsGroupInfoById(Long id);

    /**
     * 根据组号删除
     * @param groupId 组号
     * @return
     */
    int deleteTUrgentContactsGroupInfoByGroupId(String groupId);
}
