package com.zehong.system.mapper;

import java.util.List;
import com.zehong.system.domain.TInspectStatisticsInfo;

/**
 * 居民安检项统计信息Mapper接口
 * 
 * @author zehong
 * @date 2025-09-11
 */
public interface TInspectStatisticsInfoMapper 
{
    /**
     * 查询居民安检项统计信息
     * 
     * @param statisticsId 居民安检项统计信息ID
     * @return 居民安检项统计信息
     */
    public TInspectStatisticsInfo selectTInspectStatisticsInfoById(Long statisticsId);

    /**
     * 查询居民安检项统计信息列表
     * 
     * @param tInspectStatisticsInfo 居民安检项统计信息
     * @return 居民安检项统计信息集合
     */
    public List<TInspectStatisticsInfo> selectTInspectStatisticsInfoList(TInspectStatisticsInfo tInspectStatisticsInfo);

    /**
     * 新增居民安检项统计信息
     * 
     * @param tInspectStatisticsInfo 居民安检项统计信息
     * @return 结果
     */
    public int insertTInspectStatisticsInfo(TInspectStatisticsInfo tInspectStatisticsInfo);

    /**
     * 批量新增居民安检项统计信息
     * @param statisticsInfoList 居民安检项统计信息
     * @return
     */
    int batchInsertTInspectStatisticsInfo(List<TInspectStatisticsInfo> statisticsInfoList);

    /**
     * 修改居民安检项统计信息
     * 
     * @param tInspectStatisticsInfo 居民安检项统计信息
     * @return 结果
     */
    public int updateTInspectStatisticsInfo(TInspectStatisticsInfo tInspectStatisticsInfo);

    /**
     * 删除居民安检项统计信息
     * 
     * @param statisticsId 居民安检项统计信息ID
     * @return 结果
     */
    public int deleteTInspectStatisticsInfoById(Long statisticsId);

    /**
     * 批量删除居民安检项统计信息
     * 
     * @param statisticsIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTInspectStatisticsInfoByIds(Long[] statisticsIds);

    /**
     * 根据条件统计安检项信息
     * @return
     */
    List<TInspectStatisticsInfo> statisticsInspectInfoByCondition(TInspectStatisticsInfo statisticsInfo);
}
