package com.zehong.system.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zehong.common.annotation.Excel;
import com.zehong.common.core.domain.BaseEntity;

/**
 * 场站信息对象 t_site_station_info
 * 
 * @author zehong
 * @date 2023-11-02
 */
public class TSiteStationInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 场站id */
    private Long siteStationId;

    /** 场站类型（字典t_station_type） */
    @Excel(name = "场站类型", dictType = "t_station_type")
    private String siteStationType;

    /** 图片存储地址 */
    @Excel(name = "图片存储地址")
    private String pictureAddress;

    /** 场站名称 */
    @Excel(name = "场站名称")
    private String siteStationName;

    /** 权属单位 */
    private Long beyondEnterpriseId;

    /** 权属单位名称 */
    private String beyondEnterpriseName;

    /** 厂站用途 */
    @Excel(name = "厂站用途")
    private String stationDetail;

    /** 经度 */
    private BigDecimal longitude;

    /** 纬度 */
    private BigDecimal latitude;

    /** 详细地址 */
    @Excel(name = "详细地址")
    private String address;

    /** 启动时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "启动时间", width = 30, dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date enableTiem;

    /** 负责人 */
    @Excel(name = "负责人")
    private String contacts;

    /** 负责人电话 */
    @Excel(name = "负责人电话")
    private String phone;

    /** 气源种类(字典t_gas_source) */
    @Excel(name = "气源种类",dictType = "t_gas_source")
    private String gasSource;

    /** 最大储气量(立方米/吨) */
    @Excel(name = "最大储气量(立方米/吨)")
    private String bigStorage;

    /** 最大供气量(立方米/吨) */
    @Excel(name = "最大供气量(立方米/吨)")
    private String bigProvide;

    /** 危险源级别（字典t_dangerous_level ） */
    @Excel(name = "危险源级别", dictType = "t_dangerous_level")
    private String dangerousLevel;

    /** 危险源名称 */
    @Excel(name = "危险源名称")
    private String dangerousName;

    /** 储罐容积 */
    @Excel(name = "储罐容积")
    private String volume;

    /** 是否删除(0正常，1删除) */
    private String isDel;

    /** 备注 */
    private String remarks;

    private Integer jianstatus;

    private Long inspectId;

    private Long taskId;

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Integer getJianstatus() {
        return jianstatus;
    }

    public void setJianstatus(Integer jianstatus) {
        this.jianstatus = jianstatus;
    }

    public Long getInspectId() {
        return inspectId;
    }

    public void setInspectId(Long inspectId) {
        this.inspectId = inspectId;
    }

    public void setSiteStationId(Long siteStationId)
    {
        this.siteStationId = siteStationId;
    }

    public Long getSiteStationId() 
    {
        return siteStationId;
    }
    public void setSiteStationType(String siteStationType) 
    {
        this.siteStationType = siteStationType;
    }

    public String getSiteStationType() 
    {
        return siteStationType;
    }
    public void setPictureAddress(String pictureAddress) 
    {
        this.pictureAddress = pictureAddress;
    }

    public String getPictureAddress() 
    {
        return pictureAddress;
    }
    public void setSiteStationName(String siteStationName) 
    {
        this.siteStationName = siteStationName;
    }

    public String getSiteStationName() 
    {
        return siteStationName;
    }
    public void setBeyondEnterpriseId(Long beyondEnterpriseId) 
    {
        this.beyondEnterpriseId = beyondEnterpriseId;
    }

    public Long getBeyondEnterpriseId() 
    {
        return beyondEnterpriseId;
    }
    public void setBeyondEnterpriseName(String beyondEnterpriseName) 
    {
        this.beyondEnterpriseName = beyondEnterpriseName;
    }

    public String getBeyondEnterpriseName() 
    {
        return beyondEnterpriseName;
    }
    public void setStationDetail(String stationDetail) 
    {
        this.stationDetail = stationDetail;
    }

    public String getStationDetail() 
    {
        return stationDetail;
    }
    public void setLongitude(BigDecimal longitude) 
    {
        this.longitude = longitude;
    }

    public BigDecimal getLongitude() 
    {
        return longitude;
    }
    public void setLatitude(BigDecimal latitude) 
    {
        this.latitude = latitude;
    }

    public BigDecimal getLatitude() 
    {
        return latitude;
    }
    public void setAddress(String address) 
    {
        this.address = address;
    }

    public String getAddress() 
    {
        return address;
    }
    public void setEnableTiem(Date enableTiem) 
    {
        this.enableTiem = enableTiem;
    }

    public Date getEnableTiem() 
    {
        return enableTiem;
    }
    public void setContacts(String contacts) 
    {
        this.contacts = contacts;
    }

    public String getContacts() 
    {
        return contacts;
    }
    public void setPhone(String phone) 
    {
        this.phone = phone;
    }

    public String getPhone() 
    {
        return phone;
    }
    public void setGasSource(String gasSource) 
    {
        this.gasSource = gasSource;
    }

    public String getGasSource() 
    {
        return gasSource;
    }
    public void setBigStorage(String bigStorage) 
    {
        this.bigStorage = bigStorage;
    }

    public String getBigStorage() 
    {
        return bigStorage;
    }
    public void setBigProvide(String bigProvide) 
    {
        this.bigProvide = bigProvide;
    }

    public String getBigProvide() 
    {
        return bigProvide;
    }
    public void setDangerousLevel(String dangerousLevel) 
    {
        this.dangerousLevel = dangerousLevel;
    }

    public String getDangerousLevel() 
    {
        return dangerousLevel;
    }
    public void setDangerousName(String dangerousName) 
    {
        this.dangerousName = dangerousName;
    }

    public String getDangerousName() 
    {
        return dangerousName;
    }
    public void setVolume(String volume) 
    {
        this.volume = volume;
    }

    public String getVolume() 
    {
        return volume;
    }
    public void setIsDel(String isDel) 
    {
        this.isDel = isDel;
    }

    public String getIsDel() 
    {
        return isDel;
    }
    public void setRemarks(String remarks) 
    {
        this.remarks = remarks;
    }

    public String getRemarks() 
    {
        return remarks;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("siteStationId", getSiteStationId())
            .append("siteStationType", getSiteStationType())
            .append("pictureAddress", getPictureAddress())
            .append("siteStationName", getSiteStationName())
            .append("beyondEnterpriseId", getBeyondEnterpriseId())
            .append("beyondEnterpriseName", getBeyondEnterpriseName())
            .append("stationDetail", getStationDetail())
            .append("longitude", getLongitude())
            .append("latitude", getLatitude())
            .append("address", getAddress())
            .append("enableTiem", getEnableTiem())
            .append("contacts", getContacts())
            .append("phone", getPhone())
            .append("gasSource", getGasSource())
            .append("bigStorage", getBigStorage())
            .append("bigProvide", getBigProvide())
            .append("dangerousLevel", getDangerousLevel())
            .append("dangerousName", getDangerousName())
            .append("volume", getVolume())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("isDel", getIsDel())
            .append("remarks", getRemarks())
            .toString();
    }
}
