package com.zehong.web.controller.video;

import com.alibaba.fastjson.JSONObject;
import com.hikvision.artemis.sdk.ArtemisHttpUtil;
import com.hikvision.artemis.sdk.config.ArtemisConfig;
import com.zehong.common.core.domain.AjaxResult;
import com.zehong.system.domain.vo.EventSubscriptionVo;
import com.zehong.system.domain.vo.EventUnSubscriptionVo;
import org.springframework.web.bind.annotation.*;

import java.util.HashMap;
import java.util.Map;

/**
 * 海康视频接口
 */
@RestController
@RequestMapping("artemis")
public class ArtemisController {

    /**
     * 请根据自己的appKey和appSecret更换static静态块中的三个参数. [1 host]
     * 如果你选择的是和现场环境对接,host要修改为现场环境的ip,https端口默认为443，http端口默认为80.例如10.33.25.22:443 或者10.33.25.22:80
     * appKey和appSecret请按照或得到的appKey和appSecret更改.
     */
    static {
        // 代理API网关nginx服务器ip端口
        ArtemisConfig.host = "27.128.189.137:1443";
        // 秘钥appkey
        ArtemisConfig.appKey = "28616162";
        // 秘钥appSecret
        ArtemisConfig.appSecret = "5ueTWDOJ21jRbpHACAzF";
    }
    /**
     * 能力开放平台的网站路径
     */
    private static final String ARTEMIS_PATH = "/artemis";

    /**
     * 获取监控点预览取流URL
     */
    private static final String GET_PREVIEWURLS = ARTEMIS_PATH + "/api/video/v1/cameras/previewURLs";

    /**
     * 分页获取监控点资源
     */
    private static final String GET_CAMERAS = ARTEMIS_PATH + "/api/resource/v1/cameras";

    private static final String VEDIO_CONTROLLING = ARTEMIS_PATH + "/api/video/v1/ptzs/controlling";

    /**
     * 按事件类型订阅事件
     */
    private static final String EVENT_SUBSCIRPTION_BY_ENVENTTYPES = ARTEMIS_PATH  + "/api/eventService/v1/eventSubscriptionByEventTypes";

    /**
     *  按事件类型取消订阅事件
     */
    private static final String EVENT_UNSUBSCRIPTION_BY_EVENTTYPES = ARTEMIS_PATH + "/api/eventService/v1/eventUnSubscriptionByEventTypes";

    /**
     * 获取监控点预览取流URL
     * @return
     */
    @GetMapping("/getPreviewURLs")
    public AjaxResult getPreviewURLs(@RequestParam(value = "cameraIndexCode") String cameraIndexCode){
        /**
         * 根据API文档可以看出来，这是一个POST请求的Rest接口，而且传入的参数值为一个json
         * ArtemisHttpUtil工具类提供了doPostStringArtemis这个函数，一共六个参数在文档里写明其中的意思，因为接口是https，
         * 所以第一个参数path是一个hashmap类型，请put一个key-value，query为传入的参数，body为传入的json数据
         * 传入的contentType为application/json，accept不指定为null
         * header没有额外参数可不传,指定为null
         *
         */

        Map<String, String> path = new HashMap<String, String>(2) {
            {
                //根据现场环境部署确认是http还是https
                put("https://", GET_PREVIEWURLS);
            }
        };

        JSONObject jsonBody = new JSONObject();

        //jsonBody.put("cameraIndexCode", "2a9891a194c24747b277f3ea4836d433");
        jsonBody.put("cameraIndexCode", cameraIndexCode);
        jsonBody.put("streamType", 0);//0主码流，1子码流
        jsonBody.put("protocol", "ws");
        jsonBody.put("transmode", 1);
        String body = jsonBody.toJSONString();
        // post请求application/json类型参数
        String result = ArtemisHttpUtil.doPostStringArtemis(path,body,null,null,"application/json",null);
        return AjaxResult.success(JSONObject.parseObject(result));
    }

    /**
     * 分页获取监控点资源
     * @param pageNo    页码
     * @param pageSize  每页条数
     * @return
     */
    @GetMapping("/getCameras")
    public AjaxResult getCameras(@RequestParam("pageNo") int pageNo, @RequestParam("pageSize") int pageSize){

        Map<String, String> path = new HashMap<String, String>(2) {
            {
                //根据现场环境部署确认是http还是https
                put("https://", GET_CAMERAS);
            }
        };

        JSONObject jsonBody = new JSONObject();

        jsonBody.put("pageNo", pageNo);
        jsonBody.put("pageSize", pageSize);
        jsonBody.put("treeCode", 0);
        String body = jsonBody.toJSONString();
        // post请求application/json类型参数
        String result = ArtemisHttpUtil.doPostStringArtemis(path,body,null,null,"application/json",null);
        return AjaxResult.success(JSONObject.parseObject(result));
    }

    /**
     * 云控操作
     * @param cameraIndexCode
     * @param command
     * @param action
     * @return
     */
    @RequestMapping("/videoControlling")
    public AjaxResult videoControlling(@RequestParam("cameraIndexCode") String cameraIndexCode, @RequestParam("command") String command, @RequestParam("action") String action, @RequestParam("speed") String speed){
        Map<String, String> path = new HashMap<String, String>(2) {
            {
                //根据现场环境部署确认是http还是https
                put("https://", VEDIO_CONTROLLING);
            }
        };
        JSONObject jsonBody = new JSONObject();

        jsonBody.put("cameraIndexCode", cameraIndexCode);
        jsonBody.put("action", action);
        jsonBody.put("command", command);
        jsonBody.put("speed", speed);
        String body = jsonBody.toJSONString();
        // post请求application/json类型参数
        String result = ArtemisHttpUtil.doPostStringArtemis(path,body,null,null,"application/json",null);
        return AjaxResult.success(JSONObject.parseObject(result));
    }

    /**
     * 按事件类型订阅事件
     * @param eventSubscriptionVo 事件订阅实体
     * @return
     */
    @PostMapping("/eventSubscriptionByEventTypes")
    public AjaxResult eventSubscriptionByEventTypes(@RequestBody EventSubscriptionVo eventSubscriptionVo){
        Map<String, String> path = new HashMap<String, String>(2) {
            {
                //根据现场环境部署确认是http还是https
                put("https://", EVENT_SUBSCIRPTION_BY_ENVENTTYPES);
            }
        };
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("eventTypes", eventSubscriptionVo.getEventTypes());
        jsonBody.put("eventDest", eventSubscriptionVo.getEventDest());
        if(eventSubscriptionVo.getSubType() !=0){
            jsonBody.put("subType", eventSubscriptionVo.getSubType());
        }
        if(null !=eventSubscriptionVo.getEventLvl() && eventSubscriptionVo.getEventLvl().size() != 0){
            jsonBody.put("eventLvl", eventSubscriptionVo.getEventLvl());
        }
        String body = jsonBody.toJSONString();
        String result = ArtemisHttpUtil.doPostStringArtemis(path,body,null,null,"application/json",null);
        return AjaxResult.success(JSONObject.parseObject(result));
    }

    /**
     * 按事件类型取消订阅
     * @param eventUnSubscriptionVo 事件类型
     * @return
     */
    @PostMapping("/eventUnSubscriptionByEventTypes")
    public AjaxResult eventUnSubscriptionByEventTypes(@RequestBody EventUnSubscriptionVo eventUnSubscriptionVo){
        Map<String, String> path = new HashMap<String, String>(2) {
            {
                //根据现场环境部署确认是http还是https
                put("https://", EVENT_UNSUBSCRIPTION_BY_EVENTTYPES);
            }
        };
        JSONObject jsonBody = new JSONObject();
        jsonBody.put("eventTypes", eventUnSubscriptionVo.getEventTypes());
        String body = jsonBody.toJSONString();
        String result = ArtemisHttpUtil.doPostStringArtemis(path,body,null,null,"application/json",null);
        return AjaxResult.success(JSONObject.parseObject(result));
    }

}
