package com.zehong.system.service;

import java.util.List;
import com.zehong.system.domain.TSpecialDocument;

/**
 * 特殊作业单Service接口
 * 
 * @author zehong
 * @date 2023-12-04
 */
public interface ITSpecialDocumentService 
{
    /**
     * 查询特殊作业单
     * 
     * @param id 特殊作业单ID
     * @return 特殊作业单
     */
    public TSpecialDocument selectTSpecialDocumentById(Long id);

    /**
     * 查询特殊作业单列表
     * 
     * @param tSpecialDocument 特殊作业单
     * @return 特殊作业单集合
     */
    public List<TSpecialDocument> selectTSpecialDocumentList(TSpecialDocument tSpecialDocument);
    public List<TSpecialDocument> selectSpecialListwx(TSpecialDocument tSpecialDocument);

    /**
     * 新增特殊作业单
     * 
     * @param tSpecialDocument 特殊作业单
     * @return 结果
     */
    public int insertTSpecialDocument(TSpecialDocument tSpecialDocument);

    /**
     * 修改特殊作业单
     * 
     * @param tSpecialDocument 特殊作业单
     * @return 结果
     */
    public int updateTSpecialDocument(TSpecialDocument tSpecialDocument);

    /**
     * 批量删除特殊作业单
     * 
     * @param ids 需要删除的特殊作业单ID
     * @return 结果
     */
    public int deleteTSpecialDocumentByIds(Long[] ids);

    /**
     * 删除特殊作业单信息
     * 
     * @param id 特殊作业单ID
     * @return 结果
     */
    public int deleteTSpecialDocumentById(Long id);
}
