import request from '@/utils/request'

// 查询应急预案列表
export function listPlan(query) {
  return request({
    url: '/urgent/plan/list',
    method: 'get',
    params: query
  })
}

export function planList(query) {
  return request({
    url: '/urgent/plan/planList',
    method: 'get',
    params: query
  })
}

// 查询应急预案详细
export function getPlan(id) {
  return request({
    url: '/urgent/plan/' + id,
    method: 'get'
  })
}

// 新增应急预案
export function addPlan(data) {
  return request({
    url: '/urgent/plan',
    method: 'post',
    data: data
  })
}

// 修改应急预案
export function updatePlan(data) {
  return request({
    url: '/urgent/plan',
    method: 'put',
    data: data
  })
}

// 删除应急预案
export function delPlan(id) {
  return request({
    url: '/urgent/plan/' + id,
    method: 'delete'
  })
}

// 导出应急预案
export function exportPlan(query) {
  return request({
    url: '/urgent/plan/export',
    method: 'get',
    params: query
  })
}
