import request from '@/utils/request'

// 查询应急联系人列表
export function listContacts(query) {
  return request({
    url: '/urgent/contacts/list',
    method: 'get',
    params: query
  })
}

export function urgentContactsList(query) {
  return request({
    url: '/urgent/contacts/urgentContactsList',
    method: 'get',
    params: query
  })
}

// 查询应急联系人详细
export function getContacts(id) {
  return request({
    url: '/urgent/contacts/' + id,
    method: 'get'
  })
}

// 新增应急联系人
export function addContacts(data) {
  return request({
    url: '/urgent/contacts',
    method: 'post',
    data: data
  })
}

// 修改应急联系人
export function updateContacts(data) {
  return request({
    url: '/urgent/contacts',
    method: 'put',
    data: data
  })
}

// 删除应急联系人
export function delContacts(id) {
  return request({
    url: '/urgent/contacts/' + id,
    method: 'delete'
  })
}

// 导出应急联系人
export function exportContacts(query) {
  return request({
    url: '/urgent/contacts/export',
    method: 'get',
    params: query
  })
}
