import request from '@/utils/request'

// 查询管线巡线任务列表
export function listTask(query) {
  return request({
    url: '/pipetask/task/list',
    method: 'get',
    params: query
  })
}

// 查询管线巡线任务详细
export function getTask(id) {
  return request({
    url: '/pipetask/task/' + id,
    method: 'get'
  })
}

// 新增管线巡线任务
export function addTask(data) {
  return request({
    url: '/pipetask/task',
    method: 'post',
    data: data
  })
}

// 修改管线巡线任务
export function updateTask(data) {
  return request({
    url: '/pipetask/task',
    method: 'put',
    data: data
  })
}

// 删除管线巡线任务
export function delTask(id) {
  return request({
    url: '/pipetask/task/' + id,
    method: 'delete'
  })
}

// 导出管线巡线任务
export function exportTask(query) {
  return request({
    url: '/pipetask/task/export',
    method: 'get',
    params: query
  })
}

//根据巡线人统计打卡点
export function selectTaskInspectStatisticsByUser(query){
  return request({
    url: '/pipetask/task/selectTaskInspectStatisticsByUser',
    method: 'get',
    params: query
  })
}

//根据管道统计打卡点
export function selectTaskInspectStatisticsByPipe(query) {
  return request({
    url: '/pipetask/task/selectTaskInspectStatisticsByPipe',
    method: 'get',
    params: query
  })
}
