import request from '@/utils/request'

// 查询隐患日常巡检模版列表
export function listInfo(query) {
  return request({
    url: '/dangerInspect/template/list',
    method: 'get',
    params: query
  })
}

export function dangerInspectTemplateList(query) {
  return request({
    url: '/dangerInspect/template/dangerInspectTemplateList',
    method: 'get',
    params: query
  })
}

// 查询隐患日常巡检模版详细
export function getInfo(id) {
  return request({
    url: '/dangerInspect/template/' + id,
    method: 'get'
  })
}

// 新增隐患日常巡检模版
export function addInfo(data) {
  return request({
    url: '/dangerInspect/template',
    method: 'post',
    data: data
  })
}

// 修改隐患日常巡检模版
export function updateInfo(data) {
  return request({
    url: '/dangerInspect/template',
    method: 'put',
    data: data
  })
}

// 删除隐患日常巡检模版
export function delInfo(id) {
  return request({
    url: '/dangerInspect/template/' + id,
    method: 'delete'
  })
}

// 导出隐患日常巡检模版
export function exportInfo(query) {
  return request({
    url: '/dangerInspect/template/export',
    method: 'get',
    params: query
  })
}
